/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.Writer;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zul.impl.XulElement;

public class Label
extends XulElement {
    private String _value = "";
    private int _maxlength;
    private boolean _pre;
    private boolean _hyphen;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Label() {
    }

    public Label(String value) {
        this.setValue(value);
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        if (value == null) {
            value = "";
        }
        if (!Objects.equals((Object)this._value, (Object)value)) {
            this._value = value;
            this.invalidate();
        }
    }

    public int getMaxlength() {
        return this._maxlength;
    }

    public void setMaxlength(int maxlength) {
        if (maxlength < 0) {
            maxlength = 0;
        }
        if (this._maxlength != maxlength) {
            this._maxlength = maxlength;
            this.invalidate();
        }
    }

    public boolean isPre() {
        return this._pre;
    }

    public void setPre(boolean pre) {
        if (this._pre != pre) {
            this._pre = pre;
            this.invalidate();
        }
    }

    public boolean isHyphen() {
        return this._hyphen;
    }

    public void setHyphen(boolean hyphen) {
        if (this._hyphen != hyphen) {
            this._hyphen = hyphen;
            this.invalidate();
        }
    }

    private boolean isIdRequired() {
        Component p = this.getParent();
        return p == null || !this.isVisible() || !Components.isAutoId((String)this.getId()) || !Label.isRawLabel(p) || this.isAsapRequired("onClick") || this.isAsapRequired("onRightClick") || this.isAsapRequired("onDoubleClick");
    }

    private static boolean isRawLabel(Component comp) {
        LanguageDefinition langdef = ((ComponentCtrl)comp).getMilieu().getLanguageDefinition();
        return langdef != null && langdef.isRawLabel();
    }

    public String getEncodedText() {
        StringBuffer sb;
        block5: {
            sb = null;
            int len = this._value.length();
            if (this._pre) {
                int j = 0;
                while (true) {
                    int k;
                    if ((k = this._value.indexOf(10, j)) < 0) {
                        sb = this.encodeText(sb, j, len);
                        break block5;
                    }
                    if (sb == null) {
                        if (!$assertionsDisabled && j != 0) {
                            throw new AssertionError();
                        }
                        sb = new StringBuffer(this._value.length() + 10);
                    }
                    sb = this.encodeText(sb, j, k > j && this._value.charAt(k - 1) == '\r' ? k - 1 : k);
                    sb.append("<br/>");
                    j = k + 1;
                }
            }
            sb = this.encodeText(null, 0, len);
        }
        return sb != null ? sb.toString() : this._value;
    }

    private StringBuffer encodeText(StringBuffer sb, int b, int e) {
        int deta;
        int maxword = 0;
        if (this._maxlength > 0 && (deta = e - b) > this._maxlength) {
            if (this._hyphen) {
                maxword = this._maxlength;
            } else if (!this._pre) {
                int j;
                if (!$assertionsDisabled && b != 0) {
                    throw new AssertionError();
                }
                for (j = this._maxlength; j > 0 && Character.isWhitespace(this._value.charAt(j - 1)); --j) {
                }
                return new StringBuffer(j + 3).append(this._value.substring(0, j)).append("...");
            }
        }
        int cnt = 0;
        for (int j = b; j < e; ++j) {
            char cc = this._value.charAt(j);
            String val = null;
            if (cc == '\t') {
                cnt = 0;
                if (this._pre) {
                    val = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                }
            } else if (cc == ' ' || cc == '\f') {
                cnt = 0;
                if (this._pre) {
                    val = "&nbsp;";
                }
            } else {
                if (maxword > 0 && ++cnt > maxword) {
                    sb = this.alloc(sb, j);
                    int ofs = -1;
                    int k = sb.length();
                    int n = maxword;
                    while (--n >= 0) {
                        char c2 = sb.charAt(--k);
                        if (n > 0 && Label.isEndSeparator(c2)) {
                            ofs = k + 1;
                            sb.insert(ofs, ' ');
                            break;
                        }
                        if (!Label.isSeparator(c2)) continue;
                        ofs = k;
                        sb.insert(ofs, ' ');
                        break;
                    }
                    if (ofs >= 0) {
                        cnt = sb.length() - ofs;
                    } else {
                        if (Label.isSeparator(cc)) {
                            sb.append(' ');
                        } else {
                            sb.append("-<br/>");
                        }
                        cnt = 1;
                    }
                }
                switch (cc) {
                    case '<': {
                        val = "&lt;";
                        break;
                    }
                    case '>': {
                        val = "&gt;";
                        break;
                    }
                    case '&': {
                        val = "&amp;";
                    }
                }
            }
            if (val != null) {
                sb = this.alloc(sb, j).append(val);
                continue;
            }
            if (sb == null) continue;
            sb.append(cc);
        }
        return sb;
    }

    private static boolean isSeparator(char cc) {
        return !(cc > '\u007f' || cc >= '0' && cc <= '9' || cc >= 'a' && cc <= 'z' || cc >= 'A' && cc <= 'Z');
    }

    private static boolean isEndSeparator(char cc) {
        return cc == ',' || cc == ';' || cc == '.' || cc == '?' || cc == '!';
    }

    private StringBuffer alloc(StringBuffer sb, int e) {
        if (sb == null) {
            sb = new StringBuffer(this._value.length() + 10);
            sb.append(this._value.substring(0, e));
        }
        return sb;
    }

    public String getOuterAttrs() {
        String attrs = super.getOuterAttrs();
        String clkattrs = this.getAllOnClickAttrs(false);
        return clkattrs == null ? attrs : attrs + clkattrs;
    }

    public void invalidate() {
        if (this.isIdRequired()) {
            super.invalidate();
        } else {
            this.getParent().invalidate();
        }
    }

    public void redraw(Writer out) throws IOException {
        if (this.isIdRequired()) {
            super.redraw(out);
        } else {
            out.write(this.getEncodedText());
        }
    }

    public boolean isChildable() {
        return false;
    }

    static {
        $assertionsDisabled = !Label.class.desiredAssertionStatus();
    }
}

