/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.impl.FormatInputElement;
import org.zkoss.zul.mesg.MZul;

public class Doublebox
extends FormatInputElement {
    public Doublebox() {
        this.setCols(11);
    }

    public Doublebox(double value) throws WrongValueException {
        this();
        this.setValue(value);
    }

    public Doublebox(Double value) throws WrongValueException {
        this();
        this.setValue(value);
    }

    public Double getValue() throws WrongValueException {
        return (Double)this.getRawValue();
    }

    public double doubleValue() throws WrongValueException {
        Object val = this.getRawValue();
        return val != null ? (Double)val : 0.0;
    }

    public void setValue(Double value) throws WrongValueException {
        this.validate(value);
        this.setRawValue(value);
    }

    public void setValue(double value) throws WrongValueException {
        this.setValue(new Double(value));
    }

    protected Object coerceFromString(String value) throws WrongValueException {
        String val = this.toNumberOnly(value);
        if (val == null || val.length() == 0) {
            return null;
        }
        try {
            double v;
            int j;
            double d = j == 0 ? 0.0 : (v = Double.parseDouble(j < 0 ? val : val.substring(0, j)));
            if (j <= 0) {
                return new Double(v);
            }
            int len = val.length();
            for (j = val.indexOf(37); j < len && v != 0.0; v /= 100.0, ++j) {
                if (val.charAt(j) == '%') {
                    continue;
                }
                throw new WrongValueException((Component)this, MZul.NUMBER_REQUIRED, (Object)value);
            }
            return new Double(v);
        }
        catch (NumberFormatException ex) {
            throw new WrongValueException((Component)this, MZul.NUMBER_REQUIRED, (Object)value);
        }
    }

    protected String coerceToString(Object value) {
        return this.formatNumber(value, "0.##########");
    }
}

