/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.util.List;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Textbox;

public class Combobox
extends Textbox {
    private boolean _autodrop;
    private boolean _autocomplete;

    public Combobox() {
        this.setSclass("combobox");
    }

    public Combobox(String value) throws WrongValueException {
        this();
        this.setValue(value);
    }

    public boolean isAutodrop() {
        return this._autodrop;
    }

    public void setAutodrop(boolean autodrop) {
        if (this._autodrop != autodrop) {
            this._autodrop = autodrop;
            this.smartUpdate("z:adr", autodrop);
        }
    }

    public boolean isAutocomplete() {
        return this._autocomplete;
    }

    public void setAutocomplete(boolean autocomplete) {
        if (this._autocomplete != autocomplete) {
            this._autocomplete = autocomplete;
            this.smartUpdate("z:aco", autocomplete);
        }
    }

    public List getItems() {
        return this.getChildren();
    }

    public int getItemCount() {
        return this.getChildren().size();
    }

    public Comboitem getItemAtIndex(int index) {
        return (Comboitem)((Object)this.getItems().get(index));
    }

    public Comboitem appendItem(String label) {
        Comboitem item = new Comboitem(label);
        item.setParent((Component)this);
        return item;
    }

    public Comboitem removeItemAt(int index) {
        Comboitem item = this.getItemAtIndex(index);
        this.removeChild((Component)item);
        return item;
    }

    public void setMultiline(boolean multiline) {
        if (multiline) {
            throw new UnsupportedOperationException("Combobox doesn't support multiline");
        }
    }

    public void setRows(int rows) {
        if (rows != 1) {
            throw new UnsupportedOperationException("Combobox doesn't support multiple rows, " + rows);
        }
    }

    public String getOuterAttrs() {
        String attrs = super.getOuterAttrs();
        boolean aco = this.isAutocomplete();
        boolean adr = this.isAutodrop();
        if (!(this.isAsapRequired("onOpen") || aco || adr)) {
            return attrs;
        }
        StringBuffer sb = new StringBuffer(64).append(attrs);
        this.appendAsapAttr(sb, "onOpen");
        if (aco) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z:aco", (String)"true");
        }
        if (adr) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z:adr", (String)"true");
        }
        return sb.toString();
    }

    public String getInnerAttrs() {
        String attrs = super.getInnerAttrs();
        String style = this.getInnerStyle();
        return style.length() > 0 ? attrs + " style=\"" + style + '\"' : attrs;
    }

    private String getInnerStyle() {
        StringBuffer sb = new StringBuffer(32).append(HTMLs.getTextRelevantStyle((String)this.getRealStyle()));
        HTMLs.appendStyle((StringBuffer)sb, (String)"width", (String)this.getWidth());
        HTMLs.appendStyle((StringBuffer)sb, (String)"height", (String)this.getHeight());
        return sb.toString();
    }

    protected int getRealStyleFlags() {
        return super.getRealStyleFlags() | 1 | 2;
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        if (!(newChild instanceof Comboitem)) {
            throw new UiException("Unsupported child for Combobox: " + newChild);
        }
        return super.insertBefore(newChild, refChild);
    }

    public boolean isChildable() {
        return true;
    }

    public void onChildAdded(Component child) {
        super.onChildAdded(child);
        this.smartUpdate("repos", "true");
    }

    public void onChildRemoved(Component child) {
        super.onChildRemoved(child);
        this.smartUpdate("repos", "true");
    }
}

