/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.framework.operators;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.uncommons.maths.number.NumberGenerator;
import org.uncommons.maths.random.Probability;
import org.uncommons.watchmaker.framework.operators.AbstractCrossover;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringCrossover
extends AbstractCrossover<String> {
    public StringCrossover() {
        this(1);
    }

    public StringCrossover(int crossoverPoints) {
        super(crossoverPoints);
    }

    public StringCrossover(int crossoverPoints, Probability crossoverProbability) {
        super(crossoverPoints, crossoverProbability);
    }

    public StringCrossover(NumberGenerator<Integer> crossoverPointsVariable) {
        super(crossoverPointsVariable);
    }

    public StringCrossover(NumberGenerator<Integer> crossoverPointsVariable, NumberGenerator<Probability> crossoverProbabilityVariable) {
        super(crossoverPointsVariable, crossoverProbabilityVariable);
    }

    @Override
    protected List<String> mate(String parent1, String parent2, int numberOfCrossoverPoints, Random rng) {
        if (parent1.length() != parent2.length()) {
            throw new IllegalArgumentException("Cannot perform cross-over with different length parents.");
        }
        StringBuilder offspring1 = new StringBuilder(parent1);
        StringBuilder offspring2 = new StringBuilder(parent2);
        for (int i = 0; i < numberOfCrossoverPoints; ++i) {
            int crossoverIndex = 1 + rng.nextInt(parent1.length() - 1);
            for (int j = 0; j < crossoverIndex; ++j) {
                char temp = offspring1.charAt(j);
                offspring1.setCharAt(j, offspring2.charAt(j));
                offspring2.setCharAt(j, temp);
            }
        }
        ArrayList<String> result = new ArrayList<String>(2);
        result.add(offspring1.toString());
        result.add(offspring2.toString());
        return result;
    }
}

