/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.util.id;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.uncommons.util.id.IDSource;
import org.uncommons.util.id.IDSourceExhaustedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntSequenceIDSource
implements IDSource<Integer> {
    private static final long SECONDS_IN_HOUR = 3600L;
    private final Lock lock = new ReentrantLock();
    private final long startTime;
    private int lastID = -1;

    public IntSequenceIDSource(int firstValue) {
        if (firstValue < 0) {
            throw new IllegalArgumentException("Initial value must be non-negative.");
        }
        this.lastID = firstValue - 1;
        this.startTime = System.currentTimeMillis();
    }

    public IntSequenceIDSource() {
        this(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer nextID() {
        this.lock.lock();
        try {
            if (this.lastID == Integer.MAX_VALUE) {
                long hours = (System.currentTimeMillis() - this.startTime) / 3600L;
                throw new IDSourceExhaustedException("32-bit ID source exhausted after " + hours + " hours.");
            }
            ++this.lastID;
            Integer n = this.lastID;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }
}

