/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.util.concurrent;

import java.util.concurrent.ThreadFactory;
import org.uncommons.util.id.IDSource;
import org.uncommons.util.id.IntSequenceIDSource;
import org.uncommons.util.id.StringPrefixIDSource;

public class ConfigurableThreadFactory
implements ThreadFactory {
    private static final Thread.UncaughtExceptionHandler DEFAULT_EXCEPTION_HANDLER = new Thread.UncaughtExceptionHandler(){

        public void uncaughtException(Thread thread, Throwable throwable) {
            throwable.printStackTrace();
        }
    };
    private final IDSource<String> nameGenerator;
    private final int priority;
    private final boolean daemon;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    public ConfigurableThreadFactory(String namePrefix, int priority, boolean daemon) {
        this(namePrefix, priority, daemon, DEFAULT_EXCEPTION_HANDLER);
    }

    public ConfigurableThreadFactory(String namePrefix, int priority, boolean daemon, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.nameGenerator = new StringPrefixIDSource(namePrefix + '-', new IntSequenceIDSource());
        this.priority = priority;
        this.daemon = daemon;
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(runnable, this.nameGenerator.nextID());
        thread.setPriority(this.priority);
        thread.setDaemon(this.daemon);
        thread.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
        return thread;
    }
}

