/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml;

import org.springframework.util.ClassUtils;

public abstract class JaxpVersion {
    public static final int JAXP_10 = 0;
    public static final int JAXP_11 = 1;
    public static final int JAXP_13 = 3;
    public static final int JAXP_14 = 4;
    public static final int JAXP_15 = 5;
    private static final String JAXP_14_CLASS_NAME = "javax.xml.transform.stax.StAXSource";
    private static final String JAXP_15_CLASS_NAME = "javax.xml.validation.SchemaFactoryConfigurationError";
    private static int jaxpVersion;

    public static int getJaxpVersion() {
        return jaxpVersion;
    }

    public static boolean isAtLeastJaxp14() {
        return JaxpVersion.getJaxpVersion() >= 4;
    }

    static {
        ClassLoader classLoader = JaxpVersion.class.getClassLoader();
        try {
            ClassUtils.forName((String)JAXP_15_CLASS_NAME, (ClassLoader)classLoader);
            jaxpVersion = 5;
        }
        catch (ClassNotFoundException ex) {
            try {
                ClassUtils.forName((String)JAXP_14_CLASS_NAME, (ClassLoader)classLoader);
                jaxpVersion = 4;
            }
            catch (ClassNotFoundException e) {
                jaxpVersion = 3;
            }
        }
    }
}

