/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.axiom;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPFactory;
import org.springframework.util.Assert;
import org.springframework.ws.soap.SoapBody;
import org.springframework.ws.soap.axiom.AxiomSoapElement;
import org.springframework.ws.soap.axiom.CachingPayload;
import org.springframework.ws.soap.axiom.NonCachingPayload;
import org.springframework.ws.soap.axiom.Payload;
import org.springframework.ws.soap.axiom.StreamingOMDataSource;
import org.springframework.ws.soap.axiom.support.AxiomUtils;
import org.springframework.ws.stream.StreamingPayload;

abstract class AxiomSoapBody
extends AxiomSoapElement
implements SoapBody {
    private final Payload payload;

    protected AxiomSoapBody(SOAPBody axiomBody, SOAPFactory axiomFactory, boolean payloadCaching) {
        super((OMElement)axiomBody, axiomFactory);
        this.payload = payloadCaching ? new CachingPayload(axiomBody, axiomFactory) : new NonCachingPayload(axiomBody, axiomFactory);
    }

    public Source getPayloadSource() {
        return this.payload.getSource();
    }

    public Result getPayloadResult() {
        return this.payload.getResult();
    }

    public boolean hasFault() {
        return this.getAxiomBody().hasFault();
    }

    protected final SOAPBody getAxiomBody() {
        return (SOAPBody)this.getAxiomElement();
    }

    public void setStreamingPayload(StreamingPayload payload) {
        Assert.notNull((Object)payload, (String)"'payload' must not be null");
        StreamingOMDataSource dataSource = new StreamingOMDataSource(payload);
        OMSourcedElement payloadElement = this.getAxiomFactory().createOMElement((OMDataSource)dataSource, payload.getName());
        SOAPBody soapBody = this.getAxiomBody();
        AxiomUtils.removeContents((OMContainer)soapBody);
        soapBody.addChild((OMNode)payloadElement);
    }
}

