/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.util.ClassUtils;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.util.WebUtils;

public abstract class MultipartResolutionDelegate {
    public static final Object UNRESOLVABLE = new Object();
    private static Class<?> servletPartClass = null;

    public static boolean isMultipartRequest(HttpServletRequest request) {
        return WebUtils.getNativeRequest((ServletRequest)request, MultipartHttpServletRequest.class) != null || MultipartResolutionDelegate.isMultipartContent(request);
    }

    private static boolean isMultipartContent(HttpServletRequest request) {
        String contentType = request.getContentType();
        return contentType != null && contentType.toLowerCase().startsWith("multipart/");
    }

    static MultipartHttpServletRequest asMultipartHttpServletRequest(HttpServletRequest request) {
        MultipartHttpServletRequest unwrapped = WebUtils.getNativeRequest((ServletRequest)request, MultipartHttpServletRequest.class);
        if (unwrapped != null) {
            return unwrapped;
        }
        return MultipartResolutionDelegate.adaptToMultipartHttpServletRequest(request);
    }

    private static MultipartHttpServletRequest adaptToMultipartHttpServletRequest(HttpServletRequest request) {
        if (servletPartClass != null) {
            return new StandardMultipartHttpServletRequest(request);
        }
        throw new MultipartException("Expected MultipartHttpServletRequest: is a MultipartResolver configured?");
    }

    public static boolean isMultipartArgument(MethodParameter parameter) {
        Class paramType = parameter.getNestedParameterType();
        return MultipartFile.class == paramType || MultipartResolutionDelegate.isMultipartFileCollection(parameter) || MultipartResolutionDelegate.isMultipartFileArray(parameter) || servletPartClass != null && (servletPartClass == paramType || MultipartResolutionDelegate.isPartCollection(parameter) || MultipartResolutionDelegate.isPartArray(parameter));
    }

    public static Object resolveMultipartArgument(String name, MethodParameter parameter, HttpServletRequest request) throws Exception {
        boolean isMultipart;
        MultipartHttpServletRequest multipartRequest = WebUtils.getNativeRequest((ServletRequest)request, MultipartHttpServletRequest.class);
        boolean bl = isMultipart = multipartRequest != null || MultipartResolutionDelegate.isMultipartContent(request);
        if (MultipartFile.class == parameter.getNestedParameterType()) {
            if (multipartRequest == null && isMultipart) {
                multipartRequest = MultipartResolutionDelegate.adaptToMultipartHttpServletRequest(request);
            }
            return multipartRequest != null ? multipartRequest.getFile(name) : null;
        }
        if (MultipartResolutionDelegate.isMultipartFileCollection(parameter)) {
            if (multipartRequest == null && isMultipart) {
                multipartRequest = MultipartResolutionDelegate.adaptToMultipartHttpServletRequest(request);
            }
            return multipartRequest != null ? multipartRequest.getFiles(name) : null;
        }
        if (MultipartResolutionDelegate.isMultipartFileArray(parameter)) {
            if (multipartRequest == null && isMultipart) {
                multipartRequest = MultipartResolutionDelegate.adaptToMultipartHttpServletRequest(request);
            }
            if (multipartRequest != null) {
                List multipartFiles = multipartRequest.getFiles(name);
                return multipartFiles.toArray(new MultipartFile[multipartFiles.size()]);
            }
            return null;
        }
        if (servletPartClass != null) {
            if (servletPartClass == parameter.getNestedParameterType()) {
                return isMultipart ? RequestPartResolver.resolvePart(request, name) : null;
            }
            if (MultipartResolutionDelegate.isPartCollection(parameter)) {
                return isMultipart ? RequestPartResolver.resolvePartList(request, name) : null;
            }
            if (MultipartResolutionDelegate.isPartArray(parameter)) {
                return isMultipart ? RequestPartResolver.resolvePartArray(request, name) : null;
            }
        }
        return UNRESOLVABLE;
    }

    private static boolean isMultipartFileCollection(MethodParameter methodParam) {
        return MultipartFile.class == MultipartResolutionDelegate.getCollectionParameterType(methodParam);
    }

    private static boolean isMultipartFileArray(MethodParameter methodParam) {
        return MultipartFile.class == methodParam.getNestedParameterType().getComponentType();
    }

    private static boolean isPartCollection(MethodParameter methodParam) {
        return servletPartClass == MultipartResolutionDelegate.getCollectionParameterType(methodParam);
    }

    private static boolean isPartArray(MethodParameter methodParam) {
        return servletPartClass == methodParam.getNestedParameterType().getComponentType();
    }

    private static Class<?> getCollectionParameterType(MethodParameter methodParam) {
        Class valueType;
        Class paramType = methodParam.getNestedParameterType();
        if ((Collection.class == paramType || List.class.isAssignableFrom(paramType)) && (valueType = GenericCollectionTypeResolver.getCollectionParameterType((MethodParameter)methodParam)) != null) {
            return valueType;
        }
        return null;
    }

    static {
        try {
            servletPartClass = ClassUtils.forName((String)"javax.servlet.http.Part", (ClassLoader)MultipartResolutionDelegate.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static class RequestPartResolver {
        private RequestPartResolver() {
        }

        public static Object resolvePart(HttpServletRequest servletRequest, String name) throws Exception {
            return servletRequest.getPart(name);
        }

        public static Object resolvePartList(HttpServletRequest servletRequest, String name) throws Exception {
            Collection parts = servletRequest.getParts();
            ArrayList<Part> result = new ArrayList<Part>(parts.size());
            for (Part part : parts) {
                if (!part.getName().equals(name)) continue;
                result.add(part);
            }
            return result;
        }

        public static Object resolvePartArray(HttpServletRequest servletRequest, String name) throws Exception {
            Collection parts = servletRequest.getParts();
            ArrayList<Part> result = new ArrayList<Part>(parts.size());
            for (Part part : parts) {
                if (!part.getName().equals(name)) continue;
                result.add(part);
            }
            return result.toArray(new Part[result.size()]);
        }
    }
}

