/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.standard.commands;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jline.reader.History;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
public class History {
    private final org.jline.reader.History jLineHistory;

    public History(org.jline.reader.History jLineHistory) {
        this.jLineHistory = jLineHistory;
    }

    @ShellMethod(value="Display or save the history of previously run commands")
    public List<String> history(@ShellOption(help="A file to save history to.", defaultValue="__NULL__") File file) throws IOException {
        if (file == null) {
            ArrayList<String> result = new ArrayList<String>(this.jLineHistory.size());
            this.jLineHistory.forEach(e -> result.add(e.line()));
            return result;
        }
        try (FileWriter w = new FileWriter(file);){
            for (History.Entry entry : this.jLineHistory) {
                w.append(entry.line()).append(System.lineSeparator());
            }
        }
        return Collections.singletonList(String.format("Wrote %d entries to %s", this.jLineHistory.size(), file));
    }

    public static interface Command {
    }
}

