/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.userdetails;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.naming.AuthenticationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.AttributesMapperCallbackHandler;
import org.springframework.ldap.core.ContextExecutor;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.NameClassPairCallbackHandler;
import org.springframework.ldap.core.SearchExecutor;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.GrantedAuthorityImpl;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.DefaultLdapUsernameToDnMapper;
import org.springframework.security.ldap.LdapUsernameToDnMapper;
import org.springframework.security.ldap.LdapUtils;
import org.springframework.security.ldap.userdetails.InetOrgPersonContextMapper;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;
import org.springframework.security.provisioning.UserDetailsManager;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapUserDetailsManager
implements UserDetailsManager {
    private final Log logger = LogFactory.getLog(LdapUserDetailsManager.class);
    LdapUsernameToDnMapper usernameMapper = new DefaultLdapUsernameToDnMapper("cn=users", "uid");
    private DistinguishedName groupSearchBase = new DistinguishedName("cn=groups");
    private String passwordAttributeName = "userPassword";
    private String groupRoleAttributeName = "cn";
    private String groupMemberAttributeName = "uniquemember";
    private String rolePrefix = "ROLE_";
    private String groupSearchFilter = "(uniquemember={0})";
    private UserDetailsContextMapper userDetailsMapper = new InetOrgPersonContextMapper();
    private LdapTemplate template;
    private AttributesMapper roleMapper = new AttributesMapper(){

        public Object mapFromAttributes(Attributes attributes) throws NamingException {
            Attribute roleAttr = attributes.get(LdapUserDetailsManager.this.groupRoleAttributeName);
            NamingEnumeration<?> ne = roleAttr.getAll();
            Object group = ne.next();
            String role = group.toString();
            return new GrantedAuthorityImpl(LdapUserDetailsManager.this.rolePrefix + role.toUpperCase());
        }
    };
    private String[] attributesToRetrieve;

    public LdapUserDetailsManager(ContextSource contextSource) {
        this.template = new LdapTemplate(contextSource);
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        DistinguishedName dn = this.usernameMapper.buildDn(username);
        List<GrantedAuthority> authorities = this.getUserAuthorities(dn, username);
        this.logger.debug((Object)("Loading user '" + username + "' with DN '" + dn + "'"));
        DirContextAdapter userCtx = this.loadUserAsContext(dn, username);
        return this.userDetailsMapper.mapUserFromContext((DirContextOperations)userCtx, username, authorities);
    }

    private DirContextAdapter loadUserAsContext(final DistinguishedName dn, final String username) {
        return (DirContextAdapter)this.template.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                try {
                    Attributes attrs = ctx.getAttributes((Name)dn, LdapUserDetailsManager.this.attributesToRetrieve);
                    return new DirContextAdapter(attrs, (Name)LdapUtils.getFullDn(dn, ctx));
                }
                catch (javax.naming.NameNotFoundException notFound) {
                    throw new UsernameNotFoundException("User " + username + " not found", (Throwable)notFound);
                }
            }
        });
    }

    public void changePassword(final String oldPassword, String newPassword) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Assert.notNull((Object)authentication, (String)"No authentication object found in security context. Can't change current user's password!");
        String username = authentication.getName();
        this.logger.debug((Object)("Changing password for user '" + username));
        final DistinguishedName dn = this.usernameMapper.buildDn(username);
        final ModificationItem[] passwordChange = new ModificationItem[]{new ModificationItem(2, new BasicAttribute(this.passwordAttributeName, newPassword))};
        if (oldPassword == null) {
            this.template.modifyAttributes((Name)dn, passwordChange);
            return;
        }
        this.template.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext dirCtx) throws NamingException {
                LdapContext ctx = (LdapContext)dirCtx;
                ctx.removeFromEnvironment("com.sun.jndi.ldap.connect.pool");
                ctx.addToEnvironment("java.naming.security.principal", LdapUtils.getFullDn(dn, ctx).toString());
                ctx.addToEnvironment("java.naming.security.credentials", oldPassword);
                try {
                    ctx.reconnect(null);
                }
                catch (AuthenticationException e) {
                    throw new BadCredentialsException("Authentication for password change failed.");
                }
                ctx.modifyAttributes((Name)dn, passwordChange);
                return null;
            }
        });
    }

    List<GrantedAuthority> getUserAuthorities(final DistinguishedName dn, final String username) {
        SearchExecutor se = new SearchExecutor(){

            public NamingEnumeration<SearchResult> executeSearch(DirContext ctx) throws NamingException {
                DistinguishedName fullDn = LdapUtils.getFullDn(dn, ctx);
                SearchControls ctrls = new SearchControls();
                ctrls.setReturningAttributes(new String[]{LdapUserDetailsManager.this.groupRoleAttributeName});
                return ctx.search((Name)LdapUserDetailsManager.this.groupSearchBase, LdapUserDetailsManager.this.groupSearchFilter, (Object[])new String[]{fullDn.toUrl(), username}, ctrls);
            }
        };
        AttributesMapperCallbackHandler roleCollector = new AttributesMapperCallbackHandler(this.roleMapper);
        this.template.search(se, (NameClassPairCallbackHandler)roleCollector);
        return roleCollector.getList();
    }

    public void createUser(UserDetails user) {
        DirContextAdapter ctx = new DirContextAdapter();
        this.copyToContext(user, ctx);
        DistinguishedName dn = this.usernameMapper.buildDn(user.getUsername());
        List<GrantedAuthority> authorities = this.getUserAuthorities(dn, user.getUsername());
        if (authorities.size() > 0) {
            this.removeAuthorities(dn, authorities);
        }
        this.logger.debug((Object)("Creating new user '" + user.getUsername() + "' with DN '" + dn + "'"));
        this.template.bind((Name)dn, (Object)ctx, null);
        this.addAuthorities(dn, user.getAuthorities());
    }

    public void updateUser(UserDetails user) {
        DistinguishedName dn = this.usernameMapper.buildDn(user.getUsername());
        this.logger.debug((Object)("Updating user '" + user.getUsername() + "' with DN '" + dn + "'"));
        List<GrantedAuthority> authorities = this.getUserAuthorities(dn, user.getUsername());
        DirContextAdapter ctx = this.loadUserAsContext(dn, user.getUsername());
        ctx.setUpdateMode(true);
        this.copyToContext(user, ctx);
        LinkedList<ModificationItem> mods = new LinkedList<ModificationItem>(Arrays.asList(ctx.getModificationItems()));
        ListIterator modIt = mods.listIterator();
        while (modIt.hasNext()) {
            ModificationItem mod = (ModificationItem)modIt.next();
            Attribute a = mod.getAttribute();
            if (!"objectclass".equalsIgnoreCase(a.getID())) continue;
            modIt.remove();
        }
        this.template.modifyAttributes((Name)dn, mods.toArray(new ModificationItem[mods.size()]));
        this.removeAuthorities(dn, authorities);
        this.addAuthorities(dn, user.getAuthorities());
    }

    public void deleteUser(String username) {
        DistinguishedName dn = this.usernameMapper.buildDn(username);
        this.removeAuthorities(dn, this.getUserAuthorities(dn, username));
        this.template.unbind((Name)dn);
    }

    public boolean userExists(String username) {
        DistinguishedName dn = this.usernameMapper.buildDn(username);
        try {
            Object obj = this.template.lookup((Name)dn);
            if (obj instanceof Context) {
                LdapUtils.closeContext((Context)obj);
            }
            return true;
        }
        catch (NameNotFoundException e) {
            return false;
        }
    }

    protected DistinguishedName buildGroupDn(String group) {
        DistinguishedName dn = new DistinguishedName((Name)this.groupSearchBase);
        dn.add(this.groupRoleAttributeName, group.toLowerCase());
        return dn;
    }

    protected void copyToContext(UserDetails user, DirContextAdapter ctx) {
        this.userDetailsMapper.mapUserToContext(user, ctx);
    }

    protected void addAuthorities(DistinguishedName userDn, Collection<GrantedAuthority> authorities) {
        this.modifyAuthorities(userDn, authorities, 1);
    }

    protected void removeAuthorities(DistinguishedName userDn, List<GrantedAuthority> authorities) {
        this.modifyAuthorities(userDn, authorities, 3);
    }

    private void modifyAuthorities(final DistinguishedName userDn, final Collection<GrantedAuthority> authorities, final int modType) {
        this.template.executeReadWrite(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                for (GrantedAuthority authority : authorities) {
                    String group = LdapUserDetailsManager.this.convertAuthorityToGroup(authority);
                    DistinguishedName fullDn = LdapUtils.getFullDn(userDn, ctx);
                    ModificationItem addGroup = new ModificationItem(modType, new BasicAttribute(LdapUserDetailsManager.this.groupMemberAttributeName, fullDn.toUrl()));
                    ctx.modifyAttributes((Name)LdapUserDetailsManager.this.buildGroupDn(group), new ModificationItem[]{addGroup});
                }
                return null;
            }
        });
    }

    private String convertAuthorityToGroup(GrantedAuthority authority) {
        String group = authority.getAuthority();
        if (group.startsWith(this.rolePrefix)) {
            group = group.substring(this.rolePrefix.length());
        }
        return group;
    }

    public void setUsernameMapper(LdapUsernameToDnMapper usernameMapper) {
        this.usernameMapper = usernameMapper;
    }

    public void setPasswordAttributeName(String passwordAttributeName) {
        this.passwordAttributeName = passwordAttributeName;
    }

    public void setGroupSearchBase(String groupSearchBase) {
        this.groupSearchBase = new DistinguishedName(groupSearchBase);
    }

    public void setGroupRoleAttributeName(String groupRoleAttributeName) {
        this.groupRoleAttributeName = groupRoleAttributeName;
    }

    public void setAttributesToRetrieve(String[] attributesToRetrieve) {
        Assert.notNull((Object)attributesToRetrieve);
        this.attributesToRetrieve = attributesToRetrieve;
    }

    public void setUserDetailsMapper(UserDetailsContextMapper userDetailsMapper) {
        this.userDetailsMapper = userDetailsMapper;
    }

    public void setGroupMemberAttributeName(String groupMemberAttributeName) {
        Assert.hasText((String)groupMemberAttributeName);
        this.groupMemberAttributeName = groupMemberAttributeName;
        this.groupSearchFilter = "(" + groupMemberAttributeName + "={0})";
    }

    public void setRoleMapper(AttributesMapper roleMapper) {
        this.roleMapper = roleMapper;
    }
}

