/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.endpoint;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.common.util.OAuth2Utils;
import org.springframework.security.oauth2.provider.DefaultAuthorizationRequest;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.error.OAuth2AuthenticationEntryPoint;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenEndpointAuthenticationFilter
implements Filter {
    private static final Log logger = LogFactory.getLog(TokenEndpointAuthenticationFilter.class);
    private AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource = new WebAuthenticationDetailsSource();
    private AuthenticationEntryPoint authenticationEntryPoint = new OAuth2AuthenticationEntryPoint();
    private final AuthenticationManager authenticationManager;

    public TokenEndpointAuthenticationFilter(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setAuthenticationEntryPoint(AuthenticationEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource) {
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        boolean debug = logger.isDebugEnabled();
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        try {
            Authentication credentials = this.extractCredentials(request);
            if (credentials != null) {
                Authentication clientAuth;
                if (debug) {
                    logger.debug((Object)("Authentication credentials found for '" + credentials.getName() + "'"));
                }
                Authentication authResult = this.authenticationManager.authenticate(credentials);
                if (debug) {
                    logger.debug((Object)("Authentication success: " + authResult.getName()));
                }
                if ((clientAuth = SecurityContextHolder.getContext().getAuthentication()) == null) {
                    throw new BadCredentialsException("No client authentication found. Remember to put a filter upstream of the TokenEndpointAuthenticationFilter.");
                }
                DefaultAuthorizationRequest authorizationRequest = new DefaultAuthorizationRequest(this.getSingleValueMap(request), null, clientAuth.getName(), this.getScope(request));
                if (clientAuth.isAuthenticated()) {
                    authorizationRequest.setApproved(true);
                }
                SecurityContextHolder.getContext().setAuthentication((Authentication)new OAuth2Authentication(authorizationRequest, authResult));
                this.onSuccessfulAuthentication(request, response, authResult);
            }
        }
        catch (AuthenticationException failed) {
            SecurityContextHolder.clearContext();
            if (debug) {
                logger.debug((Object)("Authentication request for failed: " + (Object)((Object)failed)));
            }
            this.onUnsuccessfulAuthentication(request, response, failed);
            this.authenticationEntryPoint.commence(request, response, failed);
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private Map<String, String> getSingleValueMap(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Map parameters = request.getParameterMap();
        Iterator i$ = parameters.keySet().iterator();
        while (i$.hasNext()) {
            String key;
            String[] values = (String[])parameters.get(key = (String)i$.next());
            map.put(key, values != null && values.length > 0 ? values[0] : null);
        }
        return map;
    }

    private Collection<String> getScope(HttpServletRequest request) {
        return OAuth2Utils.parseParameterList(request.getParameter("scope"));
    }

    protected void onSuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException {
    }

    protected void onUnsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException {
    }

    protected Authentication extractCredentials(HttpServletRequest request) {
        String grantType = request.getParameter("grant_type");
        if (grantType != null && grantType.equals("password")) {
            UsernamePasswordAuthenticationToken result = new UsernamePasswordAuthenticationToken((Object)request.getParameter("username"), (Object)request.getParameter("password"));
            result.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
            return result;
        }
        return null;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

