/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.core.io;

import java.nio.ByteBuffer;
import org.springframework.core.io.Resource;
import org.springframework.geode.core.io.UnhandledResourceException;
import org.springframework.lang.NonNull;

@FunctionalInterface
public interface ResourceWriter {
    public void write(@NonNull Resource var1, byte[] var2);

    default public void write(@NonNull Resource resource, ByteBuffer data) {
        this.write(resource, data.array());
    }

    default public ResourceWriter thenWriteTo(ResourceWriter writer) {
        return writer == null ? this : (resource, data) -> {
            try {
                this.write(resource, data);
            }
            catch (UnhandledResourceException ignore) {
                writer.write(resource, data);
            }
        };
    }
}

