/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.data.gemfire.PeerRegionFactoryBean;
import org.springframework.data.gemfire.client.ClientRegionFactoryBean;
import org.springframework.data.gemfire.config.annotation.RegionConfigurer;
import org.springframework.data.repository.CrudRepository;
import org.springframework.geode.cache.RepositoryCacheLoaderRegionConfigurer;
import org.springframework.geode.cache.RepositoryCacheWriterRegionConfigurer;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class InlineCachingRegionConfigurer<T, ID>
implements RegionConfigurer {
    private final List<RegionConfigurer> regionConfigurers = new ArrayList<RegionConfigurer>();
    private final RegionConfigurer compositeRegionConfigurer = new RegionConfigurer(){

        public void configure(String beanName, ClientRegionFactoryBean<?, ?> bean) {
            InlineCachingRegionConfigurer.this.regionConfigurers.forEach(regionConfigurer -> regionConfigurer.configure(beanName, bean));
        }

        public void configure(String beanName, PeerRegionFactoryBean<?, ?> bean) {
            InlineCachingRegionConfigurer.this.regionConfigurers.forEach(regionConfigurer -> regionConfigurer.configure(beanName, bean));
        }
    };

    public InlineCachingRegionConfigurer(@NonNull CrudRepository<T, ID> repository, @Nullable Predicate<String> regionBeanName) {
        Assert.notNull(repository, (String)"CrudRepository is required");
        regionBeanName = regionBeanName != null ? regionBeanName : beanName -> false;
        this.regionConfigurers.add(this.newRepositoryCacheLoaderRegionConfigurer(repository, regionBeanName));
        this.regionConfigurers.add(this.newRepositoryCacheWriterRegionConfigurer(repository, regionBeanName));
    }

    protected RepositoryCacheLoaderRegionConfigurer<T, ID> newRepositoryCacheLoaderRegionConfigurer(@NonNull CrudRepository<T, ID> repository, @Nullable Predicate<String> regionBeanName) {
        return new RepositoryCacheLoaderRegionConfigurer<T, ID>(repository, regionBeanName);
    }

    protected RepositoryCacheWriterRegionConfigurer<T, ID> newRepositoryCacheWriterRegionConfigurer(@NonNull CrudRepository<T, ID> repository, @Nullable Predicate<String> regionBeanName) {
        return new RepositoryCacheWriterRegionConfigurer<T, ID>(repository, regionBeanName);
    }

    public void configure(String beanName, ClientRegionFactoryBean<?, ?> bean) {
        this.compositeRegionConfigurer.configure(beanName, bean);
    }

    public void configure(String beanName, PeerRegionFactoryBean<?, ?> bean) {
        this.compositeRegionConfigurer.configure(beanName, bean);
    }
}

