/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.core.Ordered;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.data.rest.webmvc.ResourceProcessorHandlerMethodReturnValueHandler;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceProcessor;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.core.EmbeddedWrapper;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

@Deprecated
public class ResourceProcessorInvoker {
    private final List<ProcessorWrapper> processors;

    public ResourceProcessorInvoker(Collection<ResourceProcessor<?>> processors) {
        Assert.notNull(processors, (String)"ResourceProcessors must not be null!");
        this.processors = new ArrayList<ProcessorWrapper>();
        for (ResourceProcessor<?> processor : processors) {
            ResolvableType processorType = ResolvableType.forClass(ResourceProcessor.class, processor.getClass());
            Class rawType = processorType.getGeneric(new int[]{0}).resolve();
            if (Resource.class.isAssignableFrom(rawType)) {
                this.processors.add(new ResourceProcessorWrapper(processor));
                continue;
            }
            if (Resources.class.isAssignableFrom(rawType)) {
                this.processors.add(new ResourcesProcessorWrapper(processor));
                continue;
            }
            this.processors.add(new DefaultProcessorWrapper(processor));
        }
        Collections.sort(this.processors, AnnotationAwareOrderComparator.INSTANCE);
    }

    public <T extends ResourceSupport> T invokeProcessorsFor(T value) {
        Assert.notNull(value, (String)"Value must not be null!");
        return this.invokeProcessorsFor(value, ResolvableType.forClass(value.getClass()));
    }

    public <T extends ResourceSupport> T invokeProcessorsFor(T value, ResolvableType referenceType) {
        Assert.notNull(value, (String)"Value must not be null!");
        Assert.notNull((Object)referenceType, (String)"Reference type must not be null!");
        if (ResourceProcessorHandlerMethodReturnValueHandler.RESOURCES_TYPE.isAssignableFrom(referenceType)) {
            Resources resources = (Resources)value;
            ResolvableType elementTargetType = ResolvableType.forClass(Resources.class, (Class)referenceType.getRawClass()).getGeneric(new int[]{0});
            ArrayList<Object> result = new ArrayList<Object>(resources.getContent().size());
            for (Object element : resources) {
                ResolvableType elementType = ResolvableType.forClass(element.getClass());
                if (!ResourceProcessorInvoker.getRawType(elementTargetType).equals(elementType.getRawClass())) {
                    elementTargetType = elementType;
                }
                result.add(this.invokeProcessorsFor(element, elementTargetType));
            }
            ReflectionUtils.setField((Field)ResourceProcessorHandlerMethodReturnValueHandler.CONTENT_FIELD, (Object)resources, result);
        }
        return (T)((ResourceSupport)this.invokeProcessorsFor((Object)value, referenceType));
    }

    private Object invokeProcessorsFor(Object value, ResolvableType type) {
        Object currentValue = value;
        for (ProcessorWrapper wrapper : this.processors) {
            if (!wrapper.supports(type, currentValue)) continue;
            currentValue = wrapper.invokeProcessor(currentValue);
        }
        return currentValue;
    }

    private static boolean isRawTypeAssignable(ResolvableType left, Class<?> right) {
        return ResourceProcessorInvoker.getRawType(left).isAssignableFrom(right);
    }

    private static Class<?> getRawType(ResolvableType type) {
        Class rawType = type.getRawClass();
        return rawType == null ? Object.class : rawType;
    }

    private static class CustomOrderAwareComparator
    extends AnnotationAwareOrderComparator {
        public static CustomOrderAwareComparator INSTANCE = new CustomOrderAwareComparator();

        private CustomOrderAwareComparator() {
        }

        protected int getOrder(Object obj) {
            return super.getOrder(obj);
        }
    }

    static class ResourcesProcessorWrapper
    extends DefaultProcessorWrapper {
        public ResourcesProcessorWrapper(ResourceProcessor<?> processor) {
            super(processor);
        }

        @Override
        public boolean supports(ResolvableType type, Object value) {
            if (!ResourceProcessorHandlerMethodReturnValueHandler.RESOURCES_TYPE.isAssignableFrom(type)) {
                return false;
            }
            return super.supports(type, value) && ResourcesProcessorWrapper.isValueTypeMatch((Resources)value, this.getTargetType());
        }

        static boolean isValueTypeMatch(Resources<?> resources, ResolvableType target) {
            Class resourcesType;
            if (resources == null) {
                return false;
            }
            Collection content = resources.getContent();
            if (content.isEmpty()) {
                return false;
            }
            ResolvableType superType = null;
            Iterator<Class> iterator = Arrays.asList(resources.getClass(), Resources.class).iterator();
            while (iterator.hasNext() && (superType = ResolvableType.forClass((Class)(resourcesType = iterator.next()), (Class)ResourceProcessorInvoker.getRawType(target))) == null) {
            }
            if (superType == null) {
                return false;
            }
            Object element = content.iterator().next();
            ResolvableType resourceType = superType.getGeneric(new int[]{0});
            if (element instanceof Resource) {
                return ResourceProcessorWrapper.isValueTypeMatch((Resource)element, resourceType);
            }
            if (element instanceof EmbeddedWrapper) {
                return ResourceProcessorInvoker.isRawTypeAssignable(resourceType, ((EmbeddedWrapper)element).getRelTargetType());
            }
            return false;
        }
    }

    private static class ResourceProcessorWrapper
    extends DefaultProcessorWrapper {
        public ResourceProcessorWrapper(ResourceProcessor<?> processor) {
            super(processor);
        }

        @Override
        public boolean supports(ResolvableType type, Object value) {
            if (!ResourceProcessorHandlerMethodReturnValueHandler.RESOURCE_TYPE.isAssignableFrom(type)) {
                return false;
            }
            return super.supports(type, value) && ResourceProcessorWrapper.isValueTypeMatch((Resource)value, this.getTargetType());
        }

        private static boolean isValueTypeMatch(Resource<?> resource, ResolvableType target) {
            if (resource == null || !ResourceProcessorInvoker.isRawTypeAssignable(target, resource.getClass())) {
                return false;
            }
            Object content = resource.getContent();
            if (content == null) {
                return false;
            }
            ResolvableType type = ResourceProcessorWrapper.findGenericType(target, Resource.class);
            return type != null && type.getGeneric(new int[]{0}).isAssignableFrom(ResolvableType.forClass(content.getClass()));
        }

        private static ResolvableType findGenericType(ResolvableType source, Class<?> type) {
            Class rawType = ResourceProcessorInvoker.getRawType(source);
            if (Object.class.equals((Object)rawType)) {
                return null;
            }
            if (rawType.equals(type)) {
                return source;
            }
            return ResourceProcessorWrapper.findGenericType(source.getSuperType(), type);
        }
    }

    private static class DefaultProcessorWrapper
    implements ProcessorWrapper {
        private final ResourceProcessor<?> processor;
        private final ResolvableType targetType;

        public DefaultProcessorWrapper(ResourceProcessor<?> processor) {
            Assert.notNull(processor, (String)"ResourceProcessor must not be null!");
            this.processor = processor;
            this.targetType = ResolvableType.forClass(ResourceProcessor.class, processor.getClass()).getGeneric(new int[]{0});
        }

        @Override
        public boolean supports(ResolvableType type, Object value) {
            return ResourceProcessorInvoker.isRawTypeAssignable(this.targetType, ResourceProcessorInvoker.getRawType(type));
        }

        @Override
        public Object invokeProcessor(Object object) {
            return this.processor.process((ResourceSupport)object);
        }

        public int getOrder() {
            return CustomOrderAwareComparator.INSTANCE.getOrder(this.processor);
        }

        public ResolvableType getTargetType() {
            return this.targetType;
        }
    }

    private static interface ProcessorWrapper
    extends Ordered {
        public boolean supports(ResolvableType var1, Object var2);

        public Object invokeProcessor(Object var1);
    }
}

