/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.KeyValue;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import java.util.List;
import java.util.concurrent.Future;
import lombok.NonNull;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceResult;
import org.springframework.util.Assert;

class LettuceListCommands
implements RedisListCommands {
    @NonNull
    private final LettuceConnection connection;

    @Override
    public Long rPush(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().rpush((Object)key, (Object[])values)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().rpush((Object)key, (Object[])values)));
                return null;
            }
            return this.getConnection().rpush((Object)key, (Object[])values);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lPush(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)values, (String)"Values must not be null!");
        Assert.noNullElements((Object[])values, (String)"Values must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().lpush((Object)key, (Object[])values)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().lpush((Object)key, (Object[])values)));
                return null;
            }
            return this.getConnection().lpush((Object)key, (Object[])values);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long rPushX(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().rpushx((Object)key, (Object[])new byte[][]{value})));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().rpushx((Object)key, (Object[])new byte[][]{value})));
                return null;
            }
            return this.getConnection().rpushx((Object)key, (Object[])new byte[][]{value});
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lPushX(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().lpushx((Object)key, (Object[])new byte[][]{value})));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().lpushx((Object)key, (Object[])new byte[][]{value})));
                return null;
            }
            return this.getConnection().lpushx((Object)key, (Object[])new byte[][]{value});
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lLen(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().llen((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().llen((Object)key)));
                return null;
            }
            return this.getConnection().llen((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> lRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().lrange((Object)key, start, end)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().lrange((Object)key, start, end)));
                return null;
            }
            return this.getConnection().lrange((Object)key, start, end);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void lTrim(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult(this.getAsyncConnection().ltrim((Object)key, start, end)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceStatusResult(this.getAsyncConnection().ltrim((Object)key, start, end)));
                return;
            }
            this.getConnection().ltrim((Object)key, start, end);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] lIndex(byte[] key, long index) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().lindex((Object)key, index)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().lindex((Object)key, index)));
                return null;
            }
            return (byte[])this.getConnection().lindex((Object)key, index);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lInsert(byte[] key, RedisListCommands.Position where, byte[] pivot, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().linsert((Object)key, LettuceConverters.toBoolean(where), (Object)pivot, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().linsert((Object)key, LettuceConverters.toBoolean(where), (Object)pivot, (Object)value)));
                return null;
            }
            return this.getConnection().linsert((Object)key, LettuceConverters.toBoolean(where), (Object)pivot, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void lSet(byte[] key, long index, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceStatusResult(this.getAsyncConnection().lset((Object)key, index, (Object)value)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceStatusResult(this.getAsyncConnection().lset((Object)key, index, (Object)value)));
                return;
            }
            this.getConnection().lset((Object)key, index, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lRem(byte[] key, long count, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().lrem((Object)key, count, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().lrem((Object)key, count, (Object)value)));
                return null;
            }
            return this.getConnection().lrem((Object)key, count, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] lPop(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().lpop((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().lpop((Object)key)));
                return null;
            }
            return (byte[])this.getConnection().lpop((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] rPop(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().rpop((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().rpop((Object)key)));
                return null;
            }
            return (byte[])this.getConnection().rpop((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Key must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.connection.getAsyncDedicatedConnection().blpop((long)timeout, (Object[])keys), LettuceConverters.keyValueToBytesList()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.connection.getAsyncDedicatedConnection().blpop((long)timeout, (Object[])keys), LettuceConverters.keyValueToBytesList()));
                return null;
            }
            return LettuceConverters.toBytesList((KeyValue<byte[], byte[]>)this.connection.getDedicatedConnection().blpop((long)timeout, (Object[])keys));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Key must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.connection.getAsyncDedicatedConnection().brpop((long)timeout, (Object[])keys), LettuceConverters.keyValueToBytesList()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.connection.getAsyncDedicatedConnection().brpop((long)timeout, (Object[])keys), LettuceConverters.keyValueToBytesList()));
                return null;
            }
            return LettuceConverters.toBytesList((KeyValue<byte[], byte[]>)this.connection.getDedicatedConnection().brpop((long)timeout, (Object[])keys));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        Assert.notNull((Object)srcKey, (String)"Source key must not be null!");
        Assert.notNull((Object)dstKey, (String)"Destination key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().rpoplpush((Object)srcKey, (Object)dstKey)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().rpoplpush((Object)srcKey, (Object)dstKey)));
                return null;
            }
            return (byte[])this.getConnection().rpoplpush((Object)srcKey, (Object)dstKey);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        Assert.notNull((Object)srcKey, (String)"Source key must not be null!");
        Assert.notNull((Object)dstKey, (String)"Destination key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.connection.getAsyncDedicatedConnection().brpoplpush((long)timeout, (Object)srcKey, (Object)dstKey)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.connection.getAsyncDedicatedConnection().brpoplpush((long)timeout, (Object)srcKey, (Object)dstKey)));
                return null;
            }
            return (byte[])this.connection.getDedicatedConnection().brpoplpush((long)timeout, (Object)srcKey, (Object)dstKey);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void pipeline(LettuceResult result) {
        this.connection.pipeline(result);
    }

    private void transaction(LettuceResult result) {
        this.connection.transaction(result);
    }

    private RedisClusterAsyncCommands<byte[], byte[]> getAsyncConnection() {
        return this.connection.getAsyncConnection();
    }

    public RedisClusterCommands<byte[], byte[]> getConnection() {
        return this.connection.getConnection();
    }

    private DataAccessException convertLettuceAccessException(Exception ex) {
        return this.connection.convertLettuceAccessException(ex);
    }

    public LettuceListCommands(@NonNull LettuceConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        this.connection = connection;
    }
}

