/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.api.reactive.RedisScriptingReactiveCommands;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.springframework.data.redis.connection.ReactiveScriptingCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LettuceReactiveScriptingCommands
implements ReactiveScriptingCommands {
    private static final ByteBuffer[] EMPTY_BUFFER_ARRAY = new ByteBuffer[0];
    private final LettuceReactiveRedisConnection connection;

    LettuceReactiveScriptingCommands(LettuceReactiveRedisConnection connection) {
        Assert.notNull((Object)connection, (String)"Connection must not be null!");
        this.connection = connection;
    }

    @Override
    public Mono<String> scriptFlush() {
        return this.connection.execute(RedisScriptingReactiveCommands::scriptFlush).next();
    }

    @Override
    public Mono<String> scriptKill() {
        return this.connection.execute(RedisScriptingReactiveCommands::scriptKill).next();
    }

    @Override
    public Mono<String> scriptLoad(ByteBuffer script) {
        Assert.notNull((Object)script, (String)"Script must not be null!");
        return this.connection.execute(cmd -> cmd.scriptLoad((Object)script)).next();
    }

    @Override
    public Flux<Boolean> scriptExists(List<String> scriptShas) {
        Assert.notEmpty(scriptShas, (String)"Script digests must not be empty!");
        return this.connection.execute(cmd -> cmd.scriptExists(scriptShas.toArray(new String[scriptShas.size()])));
    }

    @Override
    public <T> Flux<T> eval(ByteBuffer script, ReturnType returnType, int numKeys, ByteBuffer ... keysAndArgs) {
        Assert.notNull((Object)script, (String)"Script must not be null!");
        Assert.notNull((Object)((Object)returnType), (String)"ReturnType must not be null!");
        Assert.notNull((Object)keysAndArgs, (String)"Keys and args must not be null!");
        ByteBuffer[] keys = LettuceReactiveScriptingCommands.extractScriptKeys(numKeys, keysAndArgs);
        ByteBuffer[] args = LettuceReactiveScriptingCommands.extractScriptArgs(numKeys, keysAndArgs);
        String scriptBody = Charset.defaultCharset().decode(script).toString();
        return this.convertIfNecessary(this.connection.execute(cmd -> cmd.eval(scriptBody, LettuceConverters.toScriptOutputType(returnType), (Object[])keys, (Object[])args)), returnType);
    }

    @Override
    public <T> Flux<T> evalSha(String scriptSha, ReturnType returnType, int numKeys, ByteBuffer ... keysAndArgs) {
        Assert.notNull((Object)scriptSha, (String)"Script digest must not be null!");
        Assert.notNull((Object)((Object)returnType), (String)"ReturnType must not be null!");
        Assert.notNull((Object)keysAndArgs, (String)"Keys and args must not be null!");
        ByteBuffer[] keys = LettuceReactiveScriptingCommands.extractScriptKeys(numKeys, keysAndArgs);
        ByteBuffer[] args = LettuceReactiveScriptingCommands.extractScriptArgs(numKeys, keysAndArgs);
        return this.convertIfNecessary(this.connection.execute(cmd -> cmd.evalsha(scriptSha, LettuceConverters.toScriptOutputType(returnType), (Object[])keys, (Object[])args)), returnType);
    }

    private <T> Flux<T> convertIfNecessary(Flux<T> eval, ReturnType returnType) {
        if (returnType == ReturnType.MULTI) {
            return eval.flatMap(t -> t instanceof Iterable ? Flux.fromIterable((Iterable)((Iterable)t)) : Flux.just((Object)t)).flatMap(t -> t instanceof Exception ? Flux.error((Throwable)this.connection.translateException().apply((Exception)t)) : Flux.just((Object)t));
        }
        return eval;
    }

    private static ByteBuffer[] extractScriptKeys(int numKeys, ByteBuffer ... keysAndArgs) {
        return numKeys > 0 ? Arrays.copyOfRange(keysAndArgs, 0, numKeys) : EMPTY_BUFFER_ARRAY;
    }

    private static ByteBuffer[] extractScriptArgs(int numKeys, ByteBuffer ... keysAndArgs) {
        return keysAndArgs.length > numKeys ? Arrays.copyOfRange(keysAndArgs, numKeys, keysAndArgs.length) : EMPTY_BUFFER_ARRAY;
    }
}

