/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import java.nio.ByteBuffer;
import org.reactivestreams.Publisher;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.ReactiveClusterListCommands;
import org.springframework.data.redis.connection.ReactiveListCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveListCommands;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LettuceReactiveClusterListCommands
extends LettuceReactiveListCommands
implements ReactiveClusterListCommands {
    LettuceReactiveClusterListCommands(LettuceReactiveRedisConnection connection) {
        super(connection);
    }

    @Override
    public Flux<ReactiveListCommands.PopResponse> bPop(Publisher<ReactiveListCommands.BPopCommand> commands) {
        return this.getConnection().execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull(command.getKeys(), (String)"Keys must not be null!");
            Assert.notNull((Object)((Object)command.getDirection()), (String)"Direction must not be null!");
            if (ClusterSlotHashUtil.isSameSlotForAllKeys(command.getKeys())) {
                return super.bPop((Publisher<ReactiveListCommands.BPopCommand>)Mono.just((Object)command));
            }
            return Mono.error((Throwable)new InvalidDataAccessApiUsageException("All keys must map to the same slot for BPOP command."));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveListCommands.RPopLPushCommand>> rPopLPush(Publisher<ReactiveListCommands.RPopLPushCommand> commands) {
        return this.getConnection().execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getDestination(), (String)"Destination key must not be null!");
            if (ClusterSlotHashUtil.isSameSlotForAllKeys(command.getKey(), command.getDestination())) {
                return super.rPopLPush((Publisher<ReactiveListCommands.RPopLPushCommand>)Mono.just((Object)command));
            }
            Mono result = cmd.rpop((Object)command.getKey()).flatMap(value -> cmd.lpush((Object)command.getDestination(), (Object[])new ByteBuffer[]{value}).map(x -> value));
            return result.map(value -> new ReactiveRedisConnection.ByteBufferResponse<ReactiveListCommands.RPopLPushCommand>((ReactiveListCommands.RPopLPushCommand)command, (ByteBuffer)value));
        }));
    }
}

