/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.util.TypeInformation;

public class PropertyConverter {
    private final ConversionService conversionService;
    private final Neo4jPersistentProperty property;
    private final TypeInformation<?> typeInformation;
    private final Class<?> targetType;

    public PropertyConverter(ConversionService conversionService, Neo4jPersistentProperty property) {
        this.conversionService = conversionService;
        this.property = property;
        this.typeInformation = property.getTypeInformation();
        this.targetType = property.getPropertyType();
    }

    public Object serializePropertyValue(Object newVal) {
        if (newVal == null) {
            return null;
        }
        TypeInformation typeInformation = this.property.getTypeInformation();
        if (typeInformation.isCollectionLike()) {
            return this.serializeCollection(newVal, this.conversionService, typeInformation, this.targetType);
        }
        return this.conversionService.convert(newVal, this.targetType);
    }

    public Object deserializePropertyValue(Object newVal) {
        if (newVal == null) {
            return null;
        }
        if (this.typeInformation.isCollectionLike() && this.isCollectionLike(newVal)) {
            return this.deserializeCollection(newVal, this.conversionService, this.typeInformation);
        }
        return this.conversionService.convert(newVal, this.typeInformation.getType());
    }

    private boolean isCollectionLike(Object val) {
        return val != null && (val.getClass().isArray() || Collection.class.isAssignableFrom(val.getClass()));
    }

    private Object serializeCollection(Object newVal, ConversionService conversionService, TypeInformation<?> typeInformation, Class<?> targetType) {
        List<Object> values = this.convertCollection(conversionService, targetType, this.toCollection(newVal));
        return values.toArray((Object[])Array.newInstance(targetType, values.size()));
    }

    private Object deserializeCollection(Object newVal, ConversionService conversionService, TypeInformation<?> typeInformation) {
        Class actualType = typeInformation.getActualType().getType();
        List<Object> result = this.convertCollection(conversionService, actualType, this.toCollection(newVal));
        Class fieldType = typeInformation.getType();
        if (fieldType.isArray()) {
            return result.toArray((Object[])Array.newInstance(actualType, result.size()));
        }
        if (Set.class.isAssignableFrom(fieldType)) {
            return new LinkedHashSet<Object>(result);
        }
        return result;
    }

    private List<Object> convertCollection(ConversionService conversionService, Class<?> targetType, Iterable<?> values) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object value : values) {
            result.add(conversionService.convert(value, targetType));
        }
        return result;
    }

    private Iterable<?> toCollection(Object newVal) {
        if (newVal.getClass().isArray()) {
            return Arrays.asList((Object[])newVal);
        }
        return (Iterable)newVal;
    }

    boolean isObjectOrSupportedType(Object value, Neo4jPersistentProperty property) {
        return property.getType().equals(Object.class) && property.isNeo4jPropertyValue(value);
    }
}

