/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.neo4j.core.EntityState;
import org.springframework.data.neo4j.fieldaccess.DelegatingFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.FieldAccessListener;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactoryProviders;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;

public abstract class DefaultEntityState<STATE>
implements EntityState<STATE> {
    protected final Object entity;
    protected final Class<?> type;
    private final Map<Neo4jPersistentProperty, FieldAccessor> fieldAccessors = new HashMap<Neo4jPersistentProperty, FieldAccessor>();
    private final Map<Neo4jPersistentProperty, List<FieldAccessListener>> fieldAccessorListeners = new HashMap<Neo4jPersistentProperty, List<FieldAccessListener>>();
    private STATE state;
    protected static final Logger log = LoggerFactory.getLogger(DefaultEntityState.class);
    private final FieldAccessorFactoryProviders<Object> fieldAccessorFactoryProviders;
    protected final Neo4jPersistentEntity<?> persistentEntity;

    public DefaultEntityState(STATE underlyingState, Object entity, Class<?> type, DelegatingFieldAccessorFactory delegatingFieldAccessorFactory, Neo4jPersistentEntity<?> persistentEntity) {
        this.state = underlyingState;
        this.entity = entity;
        this.type = type;
        this.persistentEntity = persistentEntity;
        if (delegatingFieldAccessorFactory != null) {
            this.fieldAccessorFactoryProviders = delegatingFieldAccessorFactory.accessorFactoriesFor(persistentEntity);
            this.fieldAccessors.putAll(this.fieldAccessorFactoryProviders.getFieldAccessors());
            this.fieldAccessorListeners.putAll(this.fieldAccessorFactoryProviders.getFieldAccessListeners());
        } else {
            this.fieldAccessorFactoryProviders = null;
        }
    }

    @Override
    public abstract void createAndAssignState();

    @Override
    public Object getEntity() {
        return this.entity;
    }

    @Override
    public void setPersistentState(STATE state) {
        this.state = state;
    }

    @Override
    public boolean hasPersistentState() {
        return this.state != null;
    }

    @Override
    public STATE getPersistentState() {
        return this.state;
    }

    @Override
    public Neo4jPersistentEntity<?> getPersistentEntity() {
        return this.persistentEntity;
    }

    @Override
    public boolean isWritable(Neo4jPersistentProperty property) {
        FieldAccessor accessor = this.accessorFor(property);
        if (accessor == null) {
            return true;
        }
        return accessor.isWriteable(this.entity);
    }

    @Override
    public Object getValue(Neo4jPersistentProperty property, MappingPolicy mappingPolicy) {
        FieldAccessor accessor = this.accessorFor(property);
        if (accessor == null) {
            return null;
        }
        return accessor.getValue(this.entity, mappingPolicy);
    }

    @Override
    public Object getValue(Field field, MappingPolicy mappingPolicy) {
        return this.getValue(this.property(field), mappingPolicy);
    }

    @Override
    public Object setValue(Field field, Object newVal, MappingPolicy mappingPolicy) {
        return this.setValue(this.property(field), newVal, mappingPolicy);
    }

    @Override
    public Object setValue(Neo4jPersistentProperty property, Object newVal, MappingPolicy mappingPolicy) {
        FieldAccessor accessor = this.accessorFor(property);
        Object result = accessor != null ? accessor.setValue(this.entity, newVal, mappingPolicy) : newVal;
        this.notifyListeners(property, result);
        return result;
    }

    @Override
    public Object getDefaultValue(Neo4jPersistentProperty property) {
        FieldAccessor accessor = this.accessorFor(property);
        if (accessor == null) {
            return null;
        }
        return accessor.getDefaultValue();
    }

    protected Neo4jPersistentProperty property(Field field) {
        return (Neo4jPersistentProperty)this.persistentEntity.getPersistentProperty(field.getName());
    }

    protected FieldAccessor accessorFor(Neo4jPersistentProperty property) {
        return this.fieldAccessors.get(property);
    }

    private void notifyListeners(Neo4jPersistentProperty field, Object result) {
        if (!this.fieldAccessorListeners.containsKey(field) || this.fieldAccessorListeners.get(field) == null) {
            return;
        }
        for (FieldAccessListener listener : this.fieldAccessorListeners.get(field)) {
            listener.valueChanged(this.entity, null, result);
        }
    }

    protected Object getIdFromEntity() {
        Neo4jPersistentProperty idProperty = this.fieldAccessorFactoryProviders.getIdProperty();
        if (idProperty == null) {
            return null;
        }
        return idProperty.getValue(this.entity, idProperty.getMappingPolicy());
    }
}

