/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.neo4j.repository.GraphRepositoryFactoryBean;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class Neo4jRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    static final String NEO4J_TEMPLATE_REF = "neo4j-template-ref";
    static final String DEFAULT_NEO4J_TEMPLATE_REF = "neo4jTemplate";
    static final String DEFAULT_NEO4J_MAPPING_CONTEXT_REF = "neo4jMappingContext";
    static final String ANN_NEO4J_TEMPLATE_REF = "neo4jTemplateRef";

    public String getRepositoryFactoryClassName() {
        return GraphRepositoryFactoryBean.class.getName();
    }

    protected String getModulePrefix() {
        return "neo4j";
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyReference(DEFAULT_NEO4J_TEMPLATE_REF, attributes.getString(ANN_NEO4J_TEMPLATE_REF));
        builder.addPropertyReference(DEFAULT_NEO4J_MAPPING_CONTEXT_REF, DEFAULT_NEO4J_MAPPING_CONTEXT_REF);
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Element element = config.getElement();
        String templateRef = element.getAttribute(NEO4J_TEMPLATE_REF);
        templateRef = StringUtils.hasText((String)templateRef) ? templateRef : DEFAULT_NEO4J_TEMPLATE_REF;
        builder.addPropertyReference(DEFAULT_NEO4J_TEMPLATE_REF, templateRef);
        builder.addPropertyReference(DEFAULT_NEO4J_MAPPING_CONTEXT_REF, DEFAULT_NEO4J_MAPPING_CONTEXT_REF);
    }
}

