/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.HashSet;
import java.util.Set;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.repository.query.PartInfo;
import org.springframework.data.neo4j.repository.query.WhereClause;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.mapping.StoredEntityType;
import org.springframework.util.StringUtils;

public class TypeRestrictingWhereClause
extends WhereClause {
    private String aliases;

    public TypeRestrictingWhereClause(PartInfo partInfo, Neo4jPersistentEntity entity, Neo4jTemplate template) {
        super(partInfo, template);
        this.aliases = StringUtils.collectionToCommaDelimitedString(this.collectAliases(entity.getEntityType()));
    }

    @Override
    public String toString() {
        return String.format("(has(`%1$s`.__type__) AND `%1$s`.__type__ IN [%2$s])", this.partInfo.getIdentifier(), this.aliases);
    }

    private Set<String> collectAliases(StoredEntityType entityType) {
        HashSet<String> aliases = new HashSet<String>();
        aliases.add("'" + entityType.getAlias().toString() + "'");
        for (StoredEntityType superType : entityType.getSuperTypes()) {
            aliases.addAll(this.collectAliases(superType));
        }
        return aliases;
    }
}

