/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.geo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.mongodb.core.geo.GeoJson;
import org.springframework.data.mongodb.core.geo.GeoJsonPolygon;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class GeoJsonMultiPolygon
implements GeoJson<Iterable<GeoJsonPolygon>> {
    private static final String TYPE = "MultiPolygon";
    private List<GeoJsonPolygon> coordinates = new ArrayList<GeoJsonPolygon>();

    public GeoJsonMultiPolygon(List<GeoJsonPolygon> polygons) {
        Assert.notNull(polygons, (String)"Polygons for MultiPolygon must not be null");
        this.coordinates.addAll(polygons);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public List<GeoJsonPolygon> getCoordinates() {
        return Collections.unmodifiableList(this.coordinates);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.coordinates);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GeoJsonMultiPolygon)) {
            return false;
        }
        GeoJsonMultiPolygon other = (GeoJsonMultiPolygon)obj;
        return ObjectUtils.nullSafeEquals(this.coordinates, other.coordinates);
    }
}

