/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.mongodb.core.geo.Distance;
import org.springframework.data.mongodb.core.geo.Point;
import org.springframework.data.mongodb.core.geo.Shape;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.OrQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.QueryUtils;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MongoQueryCreator
extends AbstractQueryCreator<Query, Query> {
    private static final Log LOG = LogFactory.getLog(MongoQueryCreator.class);
    private final MongoParameterAccessor accessor;
    private final boolean isGeoNearQuery;
    private final MappingContext<?, MongoPersistentProperty> context;

    public MongoQueryCreator(PartTree tree, ConvertingParameterAccessor accessor, MappingContext<?, MongoPersistentProperty> context) {
        this(tree, accessor, context, false);
    }

    public MongoQueryCreator(PartTree tree, ConvertingParameterAccessor accessor, MappingContext<?, MongoPersistentProperty> context, boolean isGeoNearQuery) {
        super(tree, (ParameterAccessor)accessor);
        Assert.notNull(context);
        this.accessor = accessor;
        this.isGeoNearQuery = isGeoNearQuery;
        this.context = context;
    }

    protected Query create(Part part, Iterator<Object> iterator) {
        if (this.isGeoNearQuery && part.getType().equals((Object)Part.Type.NEAR)) {
            return null;
        }
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        Criteria criteria = this.from(part.getType(), Criteria.where(path.toDotPath((Converter)MongoPersistentProperty.PropertyToFieldNameConverter.INSTANCE)), (ConvertingParameterAccessor.PotentiallyConvertingIterator)iterator);
        return new Query(criteria);
    }

    protected Query and(Part part, Query base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, (Iterator)iterator);
        }
        PersistentPropertyPath path2 = this.context.getPersistentPropertyPath(part.getProperty());
        Criteria criteria = this.from(part.getType(), Criteria.where(path2.toDotPath((Converter)MongoPersistentProperty.PropertyToFieldNameConverter.INSTANCE)), (ConvertingParameterAccessor.PotentiallyConvertingIterator)iterator);
        return base.addCriteria(criteria);
    }

    protected Query or(Query base, Query query) {
        return new OrQuery(base, query);
    }

    protected Query complete(Query query, Sort sort) {
        if (query == null) {
            return null;
        }
        QueryUtils.applySorting(query, sort);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created query " + query.getQueryObject()));
        }
        return query;
    }

    private Criteria from(Part.Type type, Criteria criteria, ConvertingParameterAccessor.PotentiallyConvertingIterator parameters) {
        switch (type) {
            case GREATER_THAN: {
                return criteria.gt(parameters.nextConverted());
            }
            case GREATER_THAN_EQUAL: {
                return criteria.gte(parameters.nextConverted());
            }
            case LESS_THAN: {
                return criteria.lt(parameters.nextConverted());
            }
            case LESS_THAN_EQUAL: {
                return criteria.lte(parameters.nextConverted());
            }
            case BETWEEN: {
                return criteria.gt(parameters.nextConverted()).lt(parameters.nextConverted());
            }
            case IS_NOT_NULL: {
                return criteria.ne(null);
            }
            case IS_NULL: {
                return criteria.is(null);
            }
            case NOT_IN: {
                return criteria.nin(this.nextAsArray(parameters));
            }
            case IN: {
                return criteria.in(this.nextAsArray(parameters));
            }
            case LIKE: {
                String value = parameters.next().toString();
                return criteria.regex(this.toLikeRegex(value));
            }
            case REGEX: {
                return criteria.regex(parameters.next().toString());
            }
            case EXISTS: {
                return criteria.exists((Boolean)parameters.next());
            }
            case TRUE: {
                return criteria.is(true);
            }
            case FALSE: {
                return criteria.is(false);
            }
            case NEAR: {
                Distance distance = this.accessor.getMaxDistance();
                Point point = this.accessor.getGeoNearLocation();
                Point point2 = point = point == null ? this.nextAs(parameters, Point.class) : point;
                if (distance == null) {
                    return criteria.near(point);
                }
                if (distance.getMetric() != null) {
                    criteria.nearSphere(point);
                } else {
                    criteria.near(point);
                }
                criteria.maxDistance(distance.getNormalizedValue());
                return criteria;
            }
            case WITHIN: {
                Object parameter = parameters.next();
                return criteria.within((Shape)parameter);
            }
            case SIMPLE_PROPERTY: {
                return criteria.is(parameters.nextConverted());
            }
            case NEGATING_SIMPLE_PROPERTY: {
                return criteria.not().is(parameters.nextConverted());
            }
        }
        throw new IllegalArgumentException("Unsupported keyword!");
    }

    private <T> T nextAs(Iterator<Object> iterator, Class<T> type) {
        Object parameter = iterator.next();
        if (parameter.getClass().isAssignableFrom(type)) {
            return (T)parameter;
        }
        throw new IllegalArgumentException(String.format("Expected parameter type of %s but got %s!", type, parameter.getClass()));
    }

    private Object[] nextAsArray(ConvertingParameterAccessor.PotentiallyConvertingIterator iterator) {
        Object next = iterator.nextConverted();
        if (next instanceof Collection) {
            return ((Collection)next).toArray();
        }
        if (next.getClass().isArray()) {
            return (Object[])next;
        }
        return new Object[]{next};
    }

    private String toLikeRegex(String source) {
        return source.replaceAll("\\*", ".*");
    }
}

