/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.EntityManager;
import org.jspecify.annotations.Nullable;
import org.springframework.data.jpa.repository.query.AbstractStringBasedJpaQuery;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.JpaQueryConfiguration;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.QueryProvider;
import org.springframework.data.repository.query.QueryCreationException;
import org.springframework.data.repository.query.QueryMethod;

class SimpleJpaQuery
extends AbstractStringBasedJpaQuery {
    public SimpleJpaQuery(JpaQueryMethod method, EntityManager em, DeclaredQuery query, @Nullable DeclaredQuery countQuery, JpaQueryConfiguration queryConfiguration) {
        super(method, em, query, countQuery, queryConfiguration);
        this.validateQuery(this.getQuery(), "Query validation failed for '%s'", method);
        if (method.isPageQuery()) {
            this.validateQuery(this.getCountQuery(), "Count query validation failed for '%s'", method);
        }
    }

    private void validateQuery(QueryProvider query, String errorMessage, JpaQueryMethod method) {
        if (this.getQueryMethod().isProcedureQuery()) {
            return;
        }
        String queryString = query.getQueryString();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (EntityManager validatingEm = this.getEntityManager().getEntityManagerFactory().createEntityManager();){
                validatingEm.createQuery(queryString);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (RuntimeException e) {
            throw QueryCreationException.create((QueryMethod)method, (String)errorMessage.formatted(queryString), (Throwable)e);
        }
    }
}

