/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.QueryEnhancerFactories;
import org.springframework.data.jpa.repository.query.QueryEnhancerFactory;

public interface QueryEnhancerSelector {
    public static final QueryEnhancerSelector DEFAULT_SELECTOR = new DefaultQueryEnhancerSelector();

    public QueryEnhancerFactory select(DeclaredQuery var1);

    public static class DefaultQueryEnhancerSelector
    implements QueryEnhancerSelector {
        protected static QueryEnhancerFactory DEFAULT_NATIVE;
        protected static QueryEnhancerFactory DEFAULT_JPQL;
        private final QueryEnhancerFactory nativeQuery;
        private final QueryEnhancerFactory jpql;

        static {
            QueryEnhancerFactory queryEnhancerFactory = DEFAULT_NATIVE = QueryEnhancerFactories.jSqlParserPresent ? QueryEnhancerFactories.jsqlparser() : QueryEnhancerFactories.fallback();
            DEFAULT_JPQL = PersistenceProvider.HIBERNATE.isPresent() ? QueryEnhancerFactories.hql() : (PersistenceProvider.ECLIPSELINK.isPresent() ? QueryEnhancerFactories.eql() : QueryEnhancerFactories.jpql());
        }

        DefaultQueryEnhancerSelector() {
            this(DEFAULT_NATIVE, DEFAULT_JPQL);
        }

        protected DefaultQueryEnhancerSelector(QueryEnhancerFactory nativeQuery, QueryEnhancerFactory jpql) {
            this.nativeQuery = nativeQuery;
            this.jpql = jpql;
        }

        public static QueryEnhancerFactory jpql() {
            return DEFAULT_JPQL;
        }

        @Override
        public QueryEnhancerFactory select(DeclaredQuery query) {
            return this.jpql.supports(query) ? this.jpql : this.nativeQuery;
        }
    }
}

