/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import org.springframework.data.jpa.repository.query.QueryRenderer;
import org.springframework.data.jpa.repository.query.QueryTokenStream;
import org.springframework.data.jpa.repository.query.QueryTokens;
import org.springframework.data.repository.query.ReturnedType;

class DtoProjectionTransformerDelegate {
    private final ReturnedType returnedType;

    public DtoProjectionTransformerDelegate(ReturnedType returnedType) {
        this.returnedType = returnedType;
    }

    public QueryTokenStream transformSelectionList(QueryTokenStream selectionList) {
        if (!this.returnedType.isProjecting() || this.returnedType.getReturnedType().isInterface() || selectionList.stream().anyMatch(it -> it.equals(QueryTokens.TOKEN_NEW))) {
            return selectionList;
        }
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_NEW);
        builder.append(QueryTokens.token(this.returnedType.getReturnedType().getName()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        if (selectionList.size() == 1) {
            builder.appendInline(QueryTokenStream.concat(this.returnedType.getInputProperties(), property -> {
                QueryRenderer.QueryRendererBuilder prop = QueryRenderer.builder();
                prop.append(QueryTokens.token(selectionList.getRequiredFirst().value()));
                prop.append(QueryTokens.TOKEN_DOT);
                prop.append(QueryTokens.token(property));
                return prop.build();
            }, QueryTokens.TOKEN_COMMA));
        } else {
            builder.appendInline(selectionList);
        }
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder.build();
    }
}

