/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.AnnotationRepositoryMetadata;
import org.springframework.data.repository.core.support.DefaultRepositoryInformation;
import org.springframework.data.repository.core.support.DefaultRepositoryMetadata;
import org.springframework.data.repository.core.support.PropertiesBasedNamedQueries;
import org.springframework.data.repository.core.support.QueryCreationListener;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public abstract class RepositoryFactorySupport
implements BeanClassLoaderAware {
    private final Map<RepositoryInformationCacheKey, RepositoryInformation> REPOSITORY_INFORMATION_CACHE = new HashMap<RepositoryInformationCacheKey, RepositoryInformation>();
    private final List<RepositoryProxyPostProcessor> postProcessors = new ArrayList<RepositoryProxyPostProcessor>();
    private QueryLookupStrategy.Key queryLookupStrategyKey;
    private List<QueryCreationListener<?>> queryPostProcessors = new ArrayList();
    private NamedQueries namedQueries = PropertiesBasedNamedQueries.EMPTY;
    private ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
    private QueryCollectingQueryCreationListener collectingListener = new QueryCollectingQueryCreationListener();

    public RepositoryFactorySupport() {
        this.queryPostProcessors.add(this.collectingListener);
    }

    public void setQueryLookupStrategyKey(QueryLookupStrategy.Key key) {
        this.queryLookupStrategyKey = key;
    }

    public void setNamedQueries(NamedQueries namedQueries) {
        this.namedQueries = namedQueries == null ? PropertiesBasedNamedQueries.EMPTY : namedQueries;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader == null ? ClassUtils.getDefaultClassLoader() : classLoader;
    }

    public void addQueryCreationListener(QueryCreationListener<?> listener) {
        Assert.notNull(listener);
        this.queryPostProcessors.add(listener);
    }

    public void addRepositoryProxyPostProcessor(RepositoryProxyPostProcessor processor) {
        Assert.notNull((Object)processor);
        this.postProcessors.add(processor);
    }

    public <T> T getRepository(Class<T> repositoryInterface) {
        return this.getRepository(repositoryInterface, null);
    }

    public <T> T getRepository(Class<T> repositoryInterface, Object customImplementation) {
        RepositoryMetadata metadata = this.getRepositoryMetadata(repositoryInterface);
        Class<?> customImplementationClass = null == customImplementation ? null : customImplementation.getClass();
        RepositoryInformation information = this.getRepositoryInformation(metadata, customImplementationClass);
        this.validate(information, customImplementation);
        Object target = this.getTargetRepository(information);
        ProxyFactory result = new ProxyFactory();
        result.setTarget(target);
        result.setInterfaces(new Class[]{repositoryInterface, Repository.class});
        for (RepositoryProxyPostProcessor processor : this.postProcessors) {
            processor.postProcess(result);
        }
        result.addAdvice((Advice)new QueryExecutorMethodInterceptor(information, customImplementation, target));
        return (T)result.getProxy(this.classLoader);
    }

    RepositoryMetadata getRepositoryMetadata(Class<?> repositoryInterface) {
        return Repository.class.isAssignableFrom(repositoryInterface) ? new DefaultRepositoryMetadata(repositoryInterface) : new AnnotationRepositoryMetadata(repositoryInterface);
    }

    protected RepositoryInformation getRepositoryInformation(RepositoryMetadata metadata, Class<?> customImplementationClass) {
        RepositoryInformationCacheKey cacheKey = new RepositoryInformationCacheKey(metadata, customImplementationClass);
        RepositoryInformation repositoryInformation = this.REPOSITORY_INFORMATION_CACHE.get(cacheKey);
        if (repositoryInformation != null) {
            return repositoryInformation;
        }
        repositoryInformation = new DefaultRepositoryInformation(metadata, this.getRepositoryBaseClass(metadata), customImplementationClass);
        this.REPOSITORY_INFORMATION_CACHE.put(cacheKey, repositoryInformation);
        return repositoryInformation;
    }

    protected List<QueryMethod> getQueryMethods() {
        return this.collectingListener.getQueryMethods();
    }

    public abstract <T, ID extends Serializable> EntityInformation<T, ID> getEntityInformation(Class<T> var1);

    protected abstract Object getTargetRepository(RepositoryMetadata var1);

    protected abstract Class<?> getRepositoryBaseClass(RepositoryMetadata var1);

    protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key) {
        return null;
    }

    private void validate(RepositoryInformation repositoryInformation, Object customImplementation) {
        if (null == customImplementation && repositoryInformation.hasCustomMethod()) {
            throw new IllegalArgumentException(String.format("You have custom methods in %s but not provided a custom implementation!", repositoryInformation.getRepositoryInterface()));
        }
        this.validate(repositoryInformation);
    }

    protected void validate(RepositoryMetadata repositoryMetadata) {
    }

    private static class RepositoryInformationCacheKey {
        private final String repositoryInterfaceName;
        private final String customImplementationClassName;

        public RepositoryInformationCacheKey(RepositoryMetadata metadata, Class<?> customImplementationType) {
            this.repositoryInterfaceName = metadata.getRepositoryInterface().getName();
            this.customImplementationClassName = customImplementationType == null ? null : customImplementationType.getName();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RepositoryInformationCacheKey)) {
                return false;
            }
            RepositoryInformationCacheKey that = (RepositoryInformationCacheKey)obj;
            return this.repositoryInterfaceName.equals(that.repositoryInterfaceName) && ObjectUtils.nullSafeEquals((Object)this.customImplementationClassName, (Object)that.customImplementationClassName);
        }

        public int hashCode() {
            int result = 31;
            result += 17 * this.repositoryInterfaceName.hashCode();
            return result += 17 * ObjectUtils.nullSafeHashCode((Object)this.customImplementationClassName);
        }
    }

    private static class QueryCollectingQueryCreationListener
    implements QueryCreationListener<RepositoryQuery> {
        private List<QueryMethod> queryMethods = new ArrayList<QueryMethod>();

        private QueryCollectingQueryCreationListener() {
        }

        public List<QueryMethod> getQueryMethods() {
            return this.queryMethods;
        }

        @Override
        public void onCreation(RepositoryQuery query) {
            this.queryMethods.add(query.getQueryMethod());
        }
    }

    public class QueryExecutorMethodInterceptor
    implements MethodInterceptor {
        private final Map<Method, RepositoryQuery> queries = new ConcurrentHashMap<Method, RepositoryQuery>();
        private final Object customImplementation;
        private final RepositoryInformation repositoryInformation;
        private final Object target;

        public QueryExecutorMethodInterceptor(RepositoryInformation repositoryInformation, Object customImplementation, Object target) {
            this.repositoryInformation = repositoryInformation;
            this.customImplementation = customImplementation;
            this.target = target;
            QueryLookupStrategy lookupStrategy = RepositoryFactorySupport.this.getQueryLookupStrategy(RepositoryFactorySupport.this.queryLookupStrategyKey);
            Iterable<Method> queryMethods = repositoryInformation.getQueryMethods();
            if (lookupStrategy == null) {
                if (queryMethods.iterator().hasNext()) {
                    throw new IllegalStateException("You have defined query method in the repository but you don't have any query lookup strategy defined. The infrastructure apparently does not support query methods!");
                }
                return;
            }
            for (Method method : queryMethods) {
                RepositoryQuery query = lookupStrategy.resolveQuery(method, repositoryInformation, RepositoryFactorySupport.this.namedQueries);
                this.invokeListeners(query);
                this.queries.put(method, query);
            }
        }

        private void invokeListeners(RepositoryQuery query) {
            for (QueryCreationListener listener : RepositoryFactorySupport.this.queryPostProcessors) {
                Class typeArgument = GenericTypeResolver.resolveTypeArgument(listener.getClass(), QueryCreationListener.class);
                if (typeArgument == null || !typeArgument.isAssignableFrom(query.getClass())) continue;
                listener.onCreation(query);
            }
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            if (this.isCustomMethodInvocation(invocation)) {
                Method actualMethod = this.repositoryInformation.getTargetClassMethod(method);
                ReflectionUtils.makeAccessible((Method)actualMethod);
                return this.executeMethodOn(this.customImplementation, actualMethod, invocation.getArguments());
            }
            if (this.hasQueryFor(method)) {
                return this.queries.get(method).execute(invocation.getArguments());
            }
            Method actualMethod = this.repositoryInformation.getTargetClassMethod(method);
            return this.executeMethodOn(this.target, actualMethod, invocation.getArguments());
        }

        private Object executeMethodOn(Object target, Method method, Object[] parameters) throws Throwable {
            try {
                return method.invoke(target, parameters);
            }
            catch (Exception e) {
                org.springframework.data.repository.util.ClassUtils.unwrapReflectionException(e);
                throw new IllegalStateException("Should not occur!");
            }
        }

        private boolean hasQueryFor(Method method) {
            return this.queries.containsKey(method);
        }

        private boolean isCustomMethodInvocation(MethodInvocation invocation) {
            if (null == this.customImplementation) {
                return false;
            }
            return this.repositoryInformation.isCustomMethod(invocation.getMethod());
        }
    }
}

