/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.history;

import org.joda.time.DateTime;
import org.springframework.data.history.RevisionMetadata;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Revision<N extends Number, T>
implements Comparable<Revision<N, ?>> {
    private final RevisionMetadata<N> metadata;
    private final T entity;

    public Revision(RevisionMetadata<N> metadata, T entity) {
        Assert.notNull(metadata);
        Assert.notNull(entity);
        this.metadata = metadata;
        this.entity = entity;
    }

    public N getRevisionNumber() {
        return this.metadata.getRevisionNumber();
    }

    public DateTime getRevisionDate() {
        return this.metadata.getRevisionDate();
    }

    public T getEntity() {
        return this.entity;
    }

    public RevisionMetadata<N> getMetadata() {
        return this.metadata;
    }

    @Override
    public int compareTo(Revision<N, ?> that) {
        return ((Comparable)this.getRevisionNumber()).compareTo(that.getRevisionNumber());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Revision)) {
            return false;
        }
        Revision that = (Revision)obj;
        boolean sameRevisionNumber = this.metadata.getRevisionNumber().equals(that.metadata.getRevisionNumber());
        return !sameRevisionNumber ? false : this.entity.equals(that.entity);
    }

    public int hashCode() {
        int result = 17;
        result += 31 * this.metadata.hashCode();
        return result += 31 * this.entity.hashCode();
    }

    public String toString() {
        return String.format("Revision %s of entity %s - Revision metadata %s", this.getRevisionNumber(), this.entity, this.metadata);
    }
}

