/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.web;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.instrument.web.SleuthWebProperties;
import org.springframework.cloud.sleuth.autoconfig.instrument.web.TraceHandlerFunctionAdapterBeanPostProcessor;
import org.springframework.cloud.sleuth.http.HttpServerHandler;
import org.springframework.cloud.sleuth.instrument.web.TraceWebFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.sleuth.web.enabled"}, matchIfMissing=true)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
class TraceWebFluxConfiguration {
    TraceWebFluxConfiguration() {
    }

    @Bean
    TraceWebFilter traceFilter(Tracer tracer, HttpServerHandler httpServerHandler, CurrentTraceContext currentTraceContext, SleuthWebProperties sleuthWebProperties) {
        TraceWebFilter traceWebFilter = new TraceWebFilter(tracer, httpServerHandler, currentTraceContext);
        traceWebFilter.setOrder(sleuthWebProperties.getFilterOrder());
        return traceWebFilter;
    }

    @Bean
    static TraceHandlerFunctionAdapterBeanPostProcessor traceHandlerFunctionAdapterBeanPostProcessor(BeanFactory beanFactory) {
        return new TraceHandlerFunctionAdapterBeanPostProcessor(beanFactory);
    }
}

