/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.mongodb;

import com.mongodb.MongoClientSettings;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.mongodb.TraceAllTypesMongoClientSettingsBuilderCustomizer;
import org.springframework.cloud.sleuth.instrument.mongodb.TraceMongoClientSettingsBuilderCustomizer;
import org.springframework.cloud.sleuth.instrument.mongodb.TraceMongoClusterIdSpanCustomizer;
import org.springframework.cloud.sleuth.instrument.mongodb.TraceMongoSocketAddressSpanCustomizer;
import org.springframework.cloud.sleuth.instrument.mongodb.TraceMongoSpanCustomizer;
import org.springframework.cloud.sleuth.instrument.mongodb.TraceReactiveMongoClientSettingsBuilderCustomizer;
import org.springframework.cloud.sleuth.instrument.mongodb.TraceSynchronousMongoClientSettingsBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={BraveAutoConfiguration.class})
@AutoConfigureBefore(value={MongoAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.sleuth.mongodb.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={MongoClientSettings.Builder.class})
public class TraceMongoDbAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={EitherSynchronousOrReactiveContextProviderPresent.class})
    TraceMongoClientSettingsBuilderCustomizer traceMongoClientSettingsBuilderCustomizer(Tracer tracer, ObjectProvider<List<TraceMongoSpanCustomizer>> customizers) {
        return new TraceMongoClientSettingsBuilderCustomizer(tracer, (List)customizers.getIfAvailable(ArrayList::new));
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnMissingClass(value={"com.mongodb.client.SynchronousContextProvider"})
    @ConditionalOnClass(name={"com.mongodb.reactivestreams.client.ReactiveContextProvider"})
    TraceReactiveMongoClientSettingsBuilderCustomizer traceReactiveMongoClientSettingsBuilderCustomizer() {
        return new TraceReactiveMongoClientSettingsBuilderCustomizer();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnMissingClass(value={"com.mongodb.reactivestreams.client.ReactiveContextProvider"})
    @ConditionalOnClass(name={"com.mongodb.client.SynchronousContextProvider"})
    TraceSynchronousMongoClientSettingsBuilderCustomizer traceSynchronousMongoClientSettingsBuilderCustomizer(Tracer tracer) {
        return new TraceSynchronousMongoClientSettingsBuilderCustomizer(tracer);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"com.mongodb.client.SynchronousContextProvider", "com.mongodb.reactivestreams.client.ReactiveContextProvider"})
    TraceAllTypesMongoClientSettingsBuilderCustomizer traceAllTypesMongoClientSettingsBuilderCustomizer(Tracer tracer) {
        return new TraceAllTypesMongoClientSettingsBuilderCustomizer(tracer);
    }

    static class EitherSynchronousOrReactiveContextProviderPresent
    extends AnyNestedCondition {
        EitherSynchronousOrReactiveContextProviderPresent() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnClass(name={"com.mongodb.reactivestreams.client.ReactiveContextProvider"})
        static class OnReactiveContextProvider {
            OnReactiveContextProvider() {
            }
        }

        @ConditionalOnClass(name={"com.mongodb.client.SynchronousContextProvider"})
        static class OnSychronousContextProvider {
            OnSychronousContextProvider() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class MongoCustomizersConfiguration {
        MongoCustomizersConfiguration() {
        }

        @Bean
        TraceMongoSpanCustomizer traceMongoClusterIdSpanCustomizer() {
            return new TraceMongoClusterIdSpanCustomizer();
        }

        @Bean
        @ConditionalOnProperty(value={"spring.sleuth.mongodb.socket-address-span-customizer.enabled"})
        TraceMongoSpanCustomizer traceMongoSocketAddressSpanCustomizer() {
            return new TraceMongoSocketAddressSpanCustomizer();
        }
    }
}

