/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.appinfo.EurekaAccept;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.transport.EurekaTransportConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.cloud.netflix.eureka.CloudEurekaTransportConfig;
import org.springframework.core.Ordered;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="eureka.client")
public class EurekaClientConfigBean
implements EurekaClientConfig,
Ordered {
    public static final String PREFIX = "eureka.client";
    public static final String DEFAULT_URL = "http://localhost:8761/eureka/";
    public static final String DEFAULT_ZONE = "defaultZone";
    private static final int MINUTES = 60;
    @Autowired(required=false)
    PropertyResolver propertyResolver;
    private boolean enabled = true;
    @NestedConfigurationProperty
    private EurekaTransportConfig transport = new CloudEurekaTransportConfig();
    private int registryFetchIntervalSeconds = 30;
    private int instanceInfoReplicationIntervalSeconds = 30;
    private int initialInstanceInfoReplicationIntervalSeconds = 40;
    private int eurekaServiceUrlPollIntervalSeconds = 300;
    private String proxyPort;
    private String proxyHost;
    private String proxyUserName;
    private String proxyPassword;
    private int eurekaServerReadTimeoutSeconds = 8;
    private int eurekaServerConnectTimeoutSeconds = 5;
    private String backupRegistryImpl;
    private int eurekaServerTotalConnections = 200;
    private int eurekaServerTotalConnectionsPerHost = 50;
    private String eurekaServerURLContext;
    private String eurekaServerPort;
    private String eurekaServerDNSName;
    private String region = "us-east-1";
    private int eurekaConnectionIdleTimeoutSeconds = 30;
    private String registryRefreshSingleVipAddress;
    private int heartbeatExecutorThreadPoolSize = 2;
    private int heartbeatExecutorExponentialBackOffBound = 10;
    private int cacheRefreshExecutorThreadPoolSize = 2;
    private int cacheRefreshExecutorExponentialBackOffBound = 10;
    private Map<String, String> serviceUrl = new HashMap<String, String>();
    private boolean gZipContent;
    private boolean useDnsForFetchingServiceUrls;
    private boolean registerWithEureka;
    private boolean preferSameZoneEureka;
    private boolean logDeltaDiff;
    private boolean disableDelta;
    private String fetchRemoteRegionsRegistry;
    private Map<String, String> availabilityZones;
    private boolean filterOnlyUpInstances;
    private boolean fetchRegistry;
    private String dollarReplacement;
    private String escapeCharReplacement;
    private boolean allowRedirects;
    private boolean onDemandUpdateStatusChange;
    private String encoderName;
    private String decoderName;
    private String clientDataAccept;
    private boolean shouldUnregisterOnShutdown;
    private boolean shouldEnforceRegistrationAtInit;
    private int order;

    public EurekaClientConfigBean() {
        this.serviceUrl.put(DEFAULT_ZONE, DEFAULT_URL);
        this.gZipContent = true;
        this.useDnsForFetchingServiceUrls = false;
        this.registerWithEureka = true;
        this.preferSameZoneEureka = true;
        this.availabilityZones = new HashMap<String, String>();
        this.filterOnlyUpInstances = true;
        this.fetchRegistry = true;
        this.dollarReplacement = "_-";
        this.escapeCharReplacement = "__";
        this.allowRedirects = false;
        this.onDemandUpdateStatusChange = true;
        this.clientDataAccept = EurekaAccept.full.name();
        this.shouldUnregisterOnShutdown = true;
        this.shouldEnforceRegistrationAtInit = false;
        this.order = 0;
    }

    public boolean shouldGZipContent() {
        return this.gZipContent;
    }

    public boolean shouldUseDnsForFetchingServiceUrls() {
        return this.useDnsForFetchingServiceUrls;
    }

    public boolean shouldRegisterWithEureka() {
        return this.registerWithEureka;
    }

    public boolean shouldPreferSameZoneEureka() {
        return this.preferSameZoneEureka;
    }

    public boolean shouldLogDeltaDiff() {
        return this.logDeltaDiff;
    }

    public boolean shouldDisableDelta() {
        return this.disableDelta;
    }

    public boolean shouldUnregisterOnShutdown() {
        return this.shouldUnregisterOnShutdown;
    }

    public boolean shouldEnforceRegistrationAtInit() {
        return this.shouldEnforceRegistrationAtInit;
    }

    public String fetchRegistryForRemoteRegions() {
        return this.fetchRemoteRegionsRegistry;
    }

    public String[] getAvailabilityZones(String region) {
        String value = this.availabilityZones.get(region);
        if (value == null) {
            value = DEFAULT_ZONE;
        }
        return value.split(",");
    }

    public List<String> getEurekaServerServiceUrls(String myZone) {
        String serviceUrls = this.serviceUrl.get(myZone);
        if (serviceUrls == null || serviceUrls.isEmpty()) {
            serviceUrls = this.serviceUrl.get(DEFAULT_ZONE);
        }
        if (!StringUtils.isEmpty((Object)serviceUrls)) {
            String[] serviceUrlsSplit = StringUtils.commaDelimitedListToStringArray((String)serviceUrls);
            ArrayList<String> eurekaServiceUrls = new ArrayList<String>(serviceUrlsSplit.length);
            for (String eurekaServiceUrl : serviceUrlsSplit) {
                if (!this.endsWithSlash(eurekaServiceUrl)) {
                    eurekaServiceUrl = eurekaServiceUrl + "/";
                }
                eurekaServiceUrls.add(eurekaServiceUrl.trim());
            }
            return eurekaServiceUrls;
        }
        return new ArrayList<String>();
    }

    private boolean endsWithSlash(String url) {
        return url.endsWith("/");
    }

    public boolean shouldFilterOnlyUpInstances() {
        return this.filterOnlyUpInstances;
    }

    public boolean shouldFetchRegistry() {
        return this.fetchRegistry;
    }

    public boolean allowRedirects() {
        return this.allowRedirects;
    }

    public boolean shouldOnDemandUpdateStatusChange() {
        return this.onDemandUpdateStatusChange;
    }

    public String getExperimental(String name) {
        if (this.propertyResolver != null) {
            return (String)this.propertyResolver.getProperty("eureka.client.experimental." + name, String.class, null);
        }
        return null;
    }

    public EurekaTransportConfig getTransportConfig() {
        return this.getTransport();
    }

    public PropertyResolver getPropertyResolver() {
        return this.propertyResolver;
    }

    public void setPropertyResolver(PropertyResolver propertyResolver) {
        this.propertyResolver = propertyResolver;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public EurekaTransportConfig getTransport() {
        return this.transport;
    }

    public void setTransport(EurekaTransportConfig transport) {
        this.transport = transport;
    }

    public int getRegistryFetchIntervalSeconds() {
        return this.registryFetchIntervalSeconds;
    }

    public void setRegistryFetchIntervalSeconds(int registryFetchIntervalSeconds) {
        this.registryFetchIntervalSeconds = registryFetchIntervalSeconds;
    }

    public int getInstanceInfoReplicationIntervalSeconds() {
        return this.instanceInfoReplicationIntervalSeconds;
    }

    public void setInstanceInfoReplicationIntervalSeconds(int instanceInfoReplicationIntervalSeconds) {
        this.instanceInfoReplicationIntervalSeconds = instanceInfoReplicationIntervalSeconds;
    }

    public int getInitialInstanceInfoReplicationIntervalSeconds() {
        return this.initialInstanceInfoReplicationIntervalSeconds;
    }

    public void setInitialInstanceInfoReplicationIntervalSeconds(int initialInstanceInfoReplicationIntervalSeconds) {
        this.initialInstanceInfoReplicationIntervalSeconds = initialInstanceInfoReplicationIntervalSeconds;
    }

    public int getEurekaServiceUrlPollIntervalSeconds() {
        return this.eurekaServiceUrlPollIntervalSeconds;
    }

    public void setEurekaServiceUrlPollIntervalSeconds(int eurekaServiceUrlPollIntervalSeconds) {
        this.eurekaServiceUrlPollIntervalSeconds = eurekaServiceUrlPollIntervalSeconds;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyUserName() {
        return this.proxyUserName;
    }

    public void setProxyUserName(String proxyUserName) {
        this.proxyUserName = proxyUserName;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public int getEurekaServerReadTimeoutSeconds() {
        return this.eurekaServerReadTimeoutSeconds;
    }

    public void setEurekaServerReadTimeoutSeconds(int eurekaServerReadTimeoutSeconds) {
        this.eurekaServerReadTimeoutSeconds = eurekaServerReadTimeoutSeconds;
    }

    public int getEurekaServerConnectTimeoutSeconds() {
        return this.eurekaServerConnectTimeoutSeconds;
    }

    public void setEurekaServerConnectTimeoutSeconds(int eurekaServerConnectTimeoutSeconds) {
        this.eurekaServerConnectTimeoutSeconds = eurekaServerConnectTimeoutSeconds;
    }

    public String getBackupRegistryImpl() {
        return this.backupRegistryImpl;
    }

    public void setBackupRegistryImpl(String backupRegistryImpl) {
        this.backupRegistryImpl = backupRegistryImpl;
    }

    public int getEurekaServerTotalConnections() {
        return this.eurekaServerTotalConnections;
    }

    public void setEurekaServerTotalConnections(int eurekaServerTotalConnections) {
        this.eurekaServerTotalConnections = eurekaServerTotalConnections;
    }

    public int getEurekaServerTotalConnectionsPerHost() {
        return this.eurekaServerTotalConnectionsPerHost;
    }

    public void setEurekaServerTotalConnectionsPerHost(int eurekaServerTotalConnectionsPerHost) {
        this.eurekaServerTotalConnectionsPerHost = eurekaServerTotalConnectionsPerHost;
    }

    public String getEurekaServerURLContext() {
        return this.eurekaServerURLContext;
    }

    public void setEurekaServerURLContext(String eurekaServerURLContext) {
        this.eurekaServerURLContext = eurekaServerURLContext;
    }

    public String getEurekaServerPort() {
        return this.eurekaServerPort;
    }

    public void setEurekaServerPort(String eurekaServerPort) {
        this.eurekaServerPort = eurekaServerPort;
    }

    public String getEurekaServerDNSName() {
        return this.eurekaServerDNSName;
    }

    public void setEurekaServerDNSName(String eurekaServerDNSName) {
        this.eurekaServerDNSName = eurekaServerDNSName;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public int getEurekaConnectionIdleTimeoutSeconds() {
        return this.eurekaConnectionIdleTimeoutSeconds;
    }

    public void setEurekaConnectionIdleTimeoutSeconds(int eurekaConnectionIdleTimeoutSeconds) {
        this.eurekaConnectionIdleTimeoutSeconds = eurekaConnectionIdleTimeoutSeconds;
    }

    public String getRegistryRefreshSingleVipAddress() {
        return this.registryRefreshSingleVipAddress;
    }

    public void setRegistryRefreshSingleVipAddress(String registryRefreshSingleVipAddress) {
        this.registryRefreshSingleVipAddress = registryRefreshSingleVipAddress;
    }

    public int getHeartbeatExecutorThreadPoolSize() {
        return this.heartbeatExecutorThreadPoolSize;
    }

    public void setHeartbeatExecutorThreadPoolSize(int heartbeatExecutorThreadPoolSize) {
        this.heartbeatExecutorThreadPoolSize = heartbeatExecutorThreadPoolSize;
    }

    public int getHeartbeatExecutorExponentialBackOffBound() {
        return this.heartbeatExecutorExponentialBackOffBound;
    }

    public void setHeartbeatExecutorExponentialBackOffBound(int heartbeatExecutorExponentialBackOffBound) {
        this.heartbeatExecutorExponentialBackOffBound = heartbeatExecutorExponentialBackOffBound;
    }

    public int getCacheRefreshExecutorThreadPoolSize() {
        return this.cacheRefreshExecutorThreadPoolSize;
    }

    public void setCacheRefreshExecutorThreadPoolSize(int cacheRefreshExecutorThreadPoolSize) {
        this.cacheRefreshExecutorThreadPoolSize = cacheRefreshExecutorThreadPoolSize;
    }

    public int getCacheRefreshExecutorExponentialBackOffBound() {
        return this.cacheRefreshExecutorExponentialBackOffBound;
    }

    public void setCacheRefreshExecutorExponentialBackOffBound(int cacheRefreshExecutorExponentialBackOffBound) {
        this.cacheRefreshExecutorExponentialBackOffBound = cacheRefreshExecutorExponentialBackOffBound;
    }

    public Map<String, String> getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(Map<String, String> serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public boolean isgZipContent() {
        return this.gZipContent;
    }

    public void setgZipContent(boolean gZipContent) {
        this.gZipContent = gZipContent;
    }

    public boolean isUseDnsForFetchingServiceUrls() {
        return this.useDnsForFetchingServiceUrls;
    }

    public void setUseDnsForFetchingServiceUrls(boolean useDnsForFetchingServiceUrls) {
        this.useDnsForFetchingServiceUrls = useDnsForFetchingServiceUrls;
    }

    public boolean isRegisterWithEureka() {
        return this.registerWithEureka;
    }

    public void setRegisterWithEureka(boolean registerWithEureka) {
        this.registerWithEureka = registerWithEureka;
    }

    public boolean isPreferSameZoneEureka() {
        return this.preferSameZoneEureka;
    }

    public void setPreferSameZoneEureka(boolean preferSameZoneEureka) {
        this.preferSameZoneEureka = preferSameZoneEureka;
    }

    public boolean isLogDeltaDiff() {
        return this.logDeltaDiff;
    }

    public void setLogDeltaDiff(boolean logDeltaDiff) {
        this.logDeltaDiff = logDeltaDiff;
    }

    public boolean isDisableDelta() {
        return this.disableDelta;
    }

    public void setDisableDelta(boolean disableDelta) {
        this.disableDelta = disableDelta;
    }

    public String getFetchRemoteRegionsRegistry() {
        return this.fetchRemoteRegionsRegistry;
    }

    public void setFetchRemoteRegionsRegistry(String fetchRemoteRegionsRegistry) {
        this.fetchRemoteRegionsRegistry = fetchRemoteRegionsRegistry;
    }

    public Map<String, String> getAvailabilityZones() {
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Map<String, String> availabilityZones) {
        this.availabilityZones = availabilityZones;
    }

    public boolean isFilterOnlyUpInstances() {
        return this.filterOnlyUpInstances;
    }

    public void setFilterOnlyUpInstances(boolean filterOnlyUpInstances) {
        this.filterOnlyUpInstances = filterOnlyUpInstances;
    }

    public boolean isFetchRegistry() {
        return this.fetchRegistry;
    }

    public void setFetchRegistry(boolean fetchRegistry) {
        this.fetchRegistry = fetchRegistry;
    }

    public String getDollarReplacement() {
        return this.dollarReplacement;
    }

    public void setDollarReplacement(String dollarReplacement) {
        this.dollarReplacement = dollarReplacement;
    }

    public String getEscapeCharReplacement() {
        return this.escapeCharReplacement;
    }

    public void setEscapeCharReplacement(String escapeCharReplacement) {
        this.escapeCharReplacement = escapeCharReplacement;
    }

    public boolean isAllowRedirects() {
        return this.allowRedirects;
    }

    public void setAllowRedirects(boolean allowRedirects) {
        this.allowRedirects = allowRedirects;
    }

    public boolean isOnDemandUpdateStatusChange() {
        return this.onDemandUpdateStatusChange;
    }

    public void setOnDemandUpdateStatusChange(boolean onDemandUpdateStatusChange) {
        this.onDemandUpdateStatusChange = onDemandUpdateStatusChange;
    }

    public String getEncoderName() {
        return this.encoderName;
    }

    public void setEncoderName(String encoderName) {
        this.encoderName = encoderName;
    }

    public String getDecoderName() {
        return this.decoderName;
    }

    public void setDecoderName(String decoderName) {
        this.decoderName = decoderName;
    }

    public String getClientDataAccept() {
        return this.clientDataAccept;
    }

    public void setClientDataAccept(String clientDataAccept) {
        this.clientDataAccept = clientDataAccept;
    }

    public boolean isShouldUnregisterOnShutdown() {
        return this.shouldUnregisterOnShutdown;
    }

    public void setShouldUnregisterOnShutdown(boolean shouldUnregisterOnShutdown) {
        this.shouldUnregisterOnShutdown = shouldUnregisterOnShutdown;
    }

    public boolean isShouldEnforceRegistrationAtInit() {
        return this.shouldEnforceRegistrationAtInit;
    }

    public void setShouldEnforceRegistrationAtInit(boolean shouldEnforceRegistrationAtInit) {
        this.shouldEnforceRegistrationAtInit = shouldEnforceRegistrationAtInit;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EurekaClientConfigBean that = (EurekaClientConfigBean)o;
        return Objects.equals(this.propertyResolver, that.propertyResolver) && this.enabled == that.enabled && Objects.equals(this.transport, that.transport) && this.registryFetchIntervalSeconds == that.registryFetchIntervalSeconds && this.instanceInfoReplicationIntervalSeconds == that.instanceInfoReplicationIntervalSeconds && this.initialInstanceInfoReplicationIntervalSeconds == that.initialInstanceInfoReplicationIntervalSeconds && this.eurekaServiceUrlPollIntervalSeconds == that.eurekaServiceUrlPollIntervalSeconds && this.eurekaServerReadTimeoutSeconds == that.eurekaServerReadTimeoutSeconds && this.eurekaServerConnectTimeoutSeconds == that.eurekaServerConnectTimeoutSeconds && this.eurekaServerTotalConnections == that.eurekaServerTotalConnections && this.eurekaServerTotalConnectionsPerHost == that.eurekaServerTotalConnectionsPerHost && this.eurekaConnectionIdleTimeoutSeconds == that.eurekaConnectionIdleTimeoutSeconds && this.heartbeatExecutorThreadPoolSize == that.heartbeatExecutorThreadPoolSize && this.heartbeatExecutorExponentialBackOffBound == that.heartbeatExecutorExponentialBackOffBound && this.cacheRefreshExecutorThreadPoolSize == that.cacheRefreshExecutorThreadPoolSize && this.cacheRefreshExecutorExponentialBackOffBound == that.cacheRefreshExecutorExponentialBackOffBound && this.gZipContent == that.gZipContent && this.useDnsForFetchingServiceUrls == that.useDnsForFetchingServiceUrls && this.registerWithEureka == that.registerWithEureka && this.preferSameZoneEureka == that.preferSameZoneEureka && this.logDeltaDiff == that.logDeltaDiff && this.disableDelta == that.disableDelta && this.filterOnlyUpInstances == that.filterOnlyUpInstances && this.fetchRegistry == that.fetchRegistry && this.allowRedirects == that.allowRedirects && this.onDemandUpdateStatusChange == that.onDemandUpdateStatusChange && this.shouldUnregisterOnShutdown == that.shouldUnregisterOnShutdown && this.shouldEnforceRegistrationAtInit == that.shouldEnforceRegistrationAtInit && Objects.equals(this.proxyPort, that.proxyPort) && Objects.equals(this.proxyHost, that.proxyHost) && Objects.equals(this.proxyUserName, that.proxyUserName) && Objects.equals(this.proxyPassword, that.proxyPassword) && Objects.equals(this.backupRegistryImpl, that.backupRegistryImpl) && Objects.equals(this.eurekaServerURLContext, that.eurekaServerURLContext) && Objects.equals(this.eurekaServerPort, that.eurekaServerPort) && Objects.equals(this.eurekaServerDNSName, that.eurekaServerDNSName) && Objects.equals(this.region, that.region) && Objects.equals(this.registryRefreshSingleVipAddress, that.registryRefreshSingleVipAddress) && Objects.equals(this.serviceUrl, that.serviceUrl) && Objects.equals(this.fetchRemoteRegionsRegistry, that.fetchRemoteRegionsRegistry) && Objects.equals(this.availabilityZones, that.availabilityZones) && Objects.equals(this.dollarReplacement, that.dollarReplacement) && Objects.equals(this.escapeCharReplacement, that.escapeCharReplacement) && Objects.equals(this.encoderName, that.encoderName) && Objects.equals(this.decoderName, that.decoderName) && Objects.equals(this.clientDataAccept, that.clientDataAccept) && Objects.equals(this.order, that.order);
    }

    public int hashCode() {
        return Objects.hash(this.propertyResolver, this.enabled, this.transport, this.registryFetchIntervalSeconds, this.instanceInfoReplicationIntervalSeconds, this.initialInstanceInfoReplicationIntervalSeconds, this.eurekaServiceUrlPollIntervalSeconds, this.proxyPort, this.proxyHost, this.proxyUserName, this.proxyPassword, this.eurekaServerReadTimeoutSeconds, this.eurekaServerConnectTimeoutSeconds, this.backupRegistryImpl, this.eurekaServerTotalConnections, this.eurekaServerTotalConnectionsPerHost, this.eurekaServerURLContext, this.eurekaServerPort, this.eurekaServerDNSName, this.region, this.eurekaConnectionIdleTimeoutSeconds, this.registryRefreshSingleVipAddress, this.heartbeatExecutorThreadPoolSize, this.heartbeatExecutorExponentialBackOffBound, this.cacheRefreshExecutorThreadPoolSize, this.cacheRefreshExecutorExponentialBackOffBound, this.serviceUrl, this.gZipContent, this.useDnsForFetchingServiceUrls, this.registerWithEureka, this.preferSameZoneEureka, this.logDeltaDiff, this.disableDelta, this.fetchRemoteRegionsRegistry, this.availabilityZones, this.filterOnlyUpInstances, this.fetchRegistry, this.dollarReplacement, this.escapeCharReplacement, this.allowRedirects, this.onDemandUpdateStatusChange, this.encoderName, this.decoderName, this.clientDataAccept, this.shouldUnregisterOnShutdown, this.shouldEnforceRegistrationAtInit, this.order);
    }

    public String toString() {
        return "EurekaClientConfigBean{" + "propertyResolver=" + this.propertyResolver + ", " + "enabled=" + this.enabled + ", " + "transport=" + this.transport + ", " + "registryFetchIntervalSeconds=" + this.registryFetchIntervalSeconds + ", " + "instanceInfoReplicationIntervalSeconds=" + this.instanceInfoReplicationIntervalSeconds + ", " + "initialInstanceInfoReplicationIntervalSeconds=" + this.initialInstanceInfoReplicationIntervalSeconds + ", " + "eurekaServiceUrlPollIntervalSeconds=" + this.eurekaServiceUrlPollIntervalSeconds + ", " + "proxyPort='" + this.proxyPort + "', " + "proxyHost='" + this.proxyHost + "', " + "proxyUserName='" + this.proxyUserName + "', " + "proxyPassword='" + this.proxyPassword + "', " + "eurekaServerReadTimeoutSeconds=" + this.eurekaServerReadTimeoutSeconds + ", " + "eurekaServerConnectTimeoutSeconds=" + this.eurekaServerConnectTimeoutSeconds + ", " + "backupRegistryImpl='" + this.backupRegistryImpl + "', " + "eurekaServerTotalConnections=" + this.eurekaServerTotalConnections + ", " + "eurekaServerTotalConnectionsPerHost=" + this.eurekaServerTotalConnectionsPerHost + ", " + "eurekaServerURLContext='" + this.eurekaServerURLContext + "', " + "eurekaServerPort='" + this.eurekaServerPort + "', " + "eurekaServerDNSName='" + this.eurekaServerDNSName + "', " + "region='" + this.region + "', " + "eurekaConnectionIdleTimeoutSeconds=" + this.eurekaConnectionIdleTimeoutSeconds + ", " + "registryRefreshSingleVipAddress='" + this.registryRefreshSingleVipAddress + "', " + "heartbeatExecutorThreadPoolSize=" + this.heartbeatExecutorThreadPoolSize + ", " + "heartbeatExecutorExponentialBackOffBound=" + this.heartbeatExecutorExponentialBackOffBound + ", " + "cacheRefreshExecutorThreadPoolSize=" + this.cacheRefreshExecutorThreadPoolSize + ", " + "cacheRefreshExecutorExponentialBackOffBound=" + this.cacheRefreshExecutorExponentialBackOffBound + ", " + "serviceUrl=" + this.serviceUrl + ", " + "gZipContent=" + this.gZipContent + ", " + "useDnsForFetchingServiceUrls=" + this.useDnsForFetchingServiceUrls + ", " + "registerWithEureka=" + this.registerWithEureka + ", " + "preferSameZoneEureka=" + this.preferSameZoneEureka + ", " + "logDeltaDiff=" + this.logDeltaDiff + ", " + "disableDelta=" + this.disableDelta + ", " + "fetchRemoteRegionsRegistry='" + this.fetchRemoteRegionsRegistry + "', " + "availabilityZones=" + this.availabilityZones + ", " + "filterOnlyUpInstances=" + this.filterOnlyUpInstances + ", " + "fetchRegistry=" + this.fetchRegistry + ", " + "dollarReplacement='" + this.dollarReplacement + "', " + "escapeCharReplacement='" + this.escapeCharReplacement + "', " + "allowRedirects=" + this.allowRedirects + ", " + "onDemandUpdateStatusChange=" + this.onDemandUpdateStatusChange + ", " + "encoderName='" + this.encoderName + "', " + "decoderName='" + this.decoderName + "', " + "clientDataAccept='" + this.clientDataAccept + "', " + "shouldUnregisterOnShutdown='" + this.shouldUnregisterOnShutdown + "', " + "shouldEnforceRegistrationAtInit='" + this.shouldEnforceRegistrationAtInit + "', " + "order='" + this.order + "'}";
    }
}

