/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.info;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Properties;
import org.springframework.boot.info.InfoProperties;

public class BuildProperties
extends InfoProperties {
    public BuildProperties(Properties entries) {
        super(BuildProperties.processEntries(entries));
    }

    public String getGroup() {
        return this.get("group");
    }

    public String getArtifact() {
        return this.get("artifact");
    }

    public String getName() {
        return this.get("name");
    }

    public String getVersion() {
        return this.get("version");
    }

    public Instant getTime() {
        return this.getInstant("time");
    }

    private static Properties processEntries(Properties properties) {
        BuildProperties.coerceDate(properties, "time");
        return properties;
    }

    private static void coerceDate(Properties properties, String key) {
        String value = properties.getProperty(key);
        if (value != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
            try {
                String updatedValue = String.valueOf(format.parse(value).getTime());
                properties.setProperty(key, updatedValue);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }
}

