/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms.hornetq;

import javax.jms.ConnectionFactory;
import javax.jms.XAConnectionFactory;
import javax.transaction.TransactionManager;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.hornetq.jms.client.HornetQXAConnectionFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jms.hornetq.HornetQConnectionFactoryFactory;
import org.springframework.boot.autoconfigure.jms.hornetq.HornetQProperties;
import org.springframework.boot.jta.XAConnectionFactoryWrapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnMissingBean(value={ConnectionFactory.class})
@ConditionalOnClass(value={TransactionManager.class})
@ConditionalOnBean(value={XAConnectionFactoryWrapper.class})
class HornetQXAConnectionFactoryConfiguration {
    HornetQXAConnectionFactoryConfiguration() {
    }

    @Primary
    @Bean(name={"jmsConnectionFactory", "xaJmsConnectionFactory"})
    public ConnectionFactory jmsConnectionFactory(ListableBeanFactory beanFactory, HornetQProperties properties, XAConnectionFactoryWrapper wrapper) throws Exception {
        return wrapper.wrapConnectionFactory((XAConnectionFactory)new HornetQConnectionFactoryFactory(beanFactory, properties).createConnectionFactory(HornetQXAConnectionFactory.class));
    }

    @Bean
    public HornetQConnectionFactory nonXaJmsConnectionFactory(ListableBeanFactory beanFactory, HornetQProperties properties) {
        return new HornetQConnectionFactoryFactory(beanFactory, properties).createConnectionFactory(HornetQConnectionFactory.class);
    }
}

