/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect;

import java.lang.reflect.Type;

public final class Parameter {
    private final int index;
    private final String name;
    private final Class<?> type;
    private final Type genericType;

    public Parameter(int index, String name, Class<?> type, Type genericType) {
        this.index = index;
        this.name = name;
        this.type = type;
        this.genericType = genericType;
    }

    public Parameter(int index, String id, Class<?> type) {
        this(index, id, type, type);
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter parameter = (Parameter)o;
        if (this.index != parameter.index) {
            return false;
        }
        if (this.name != null ? !this.name.equals(parameter.name) : parameter.name != null) {
            return false;
        }
        if (!this.type.equals(parameter.type)) {
            return false;
        }
        return !(this.genericType == null ? parameter.genericType != null : !this.genericType.equals(parameter.genericType));
    }

    public int hashCode() {
        int result = this.index;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.genericType != null ? this.genericType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Parameter{name='" + this.name + "', type=" + String.valueOf(this.type) + ", resolvedType=" + String.valueOf(this.genericType) + "}";
    }
}

