/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.log.LoggingManager;
import org.openqa.selenium.remote.server.rest.RestishHandler;

public class NewSession
implements RestishHandler<Response>,
JsonParametersAware {
    private volatile DriverSessions allSessions;
    private volatile Capabilities desiredCapabilities;
    private volatile SessionId sessionId;

    public NewSession(DriverSessions allSession) {
        this.allSessions = allSession;
    }

    public Capabilities getCapabilities() {
        return this.desiredCapabilities;
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        this.desiredCapabilities = new DesiredCapabilities((Map)allParameters.get("desiredCapabilities"));
    }

    @Override
    public Response handle() throws Exception {
        this.sessionId = this.allSessions.newSession((Capabilities)(this.desiredCapabilities != null ? this.desiredCapabilities : new DesiredCapabilities()));
        HashMap capabilities = Maps.newHashMap((Map)this.allSessions.get(this.sessionId).getCapabilities().asMap());
        capabilities.put("webdriver.remote.sessionid", this.sessionId.toString());
        if (this.desiredCapabilities != null) {
            LoggingManager.perSessionLogHandler().configureLogging((LoggingPreferences)this.desiredCapabilities.getCapability("loggingPrefs"));
        }
        LoggingManager.perSessionLogHandler().attachToCurrentThread(this.sessionId);
        Response response = new Response();
        response.setSessionId(this.sessionId.toString());
        response.setValue((Object)capabilities);
        return response;
    }

    public String getSessionId() {
        return this.sessionId.toString();
    }

    public String toString() {
        return String.format("[new session: %s]", this.desiredCapabilities);
    }
}

