/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BrowserStringParser {
    public Result parseBrowserStartCommand(String browserIdentifier, String userBrowserSpecification) {
        Pattern pattern = Pattern.compile("^\\*?" + browserIdentifier + "\\s*(\\s(.*))?$");
        Matcher matcher = pattern.matcher(userBrowserSpecification);
        if (!matcher.find()) {
            return new Result(false);
        }
        String customLauncher = matcher.group(2) == null || "".equals(matcher.group(2).trim()) ? null : matcher.group(2).trim();
        return new Result(true, "".equals(customLauncher) ? null : customLauncher);
    }

    public class Result {
        private boolean match;
        private String customLauncher;

        public Result(boolean match, String customLauncher) {
            this.match = match;
            this.customLauncher = customLauncher;
        }

        public Result(boolean match) {
            this(match, null);
        }

        public boolean match() {
            return this.match;
        }

        public String customLauncher() {
            return this.customLauncher;
        }
    }
}

