/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.seleniumemulation;

import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.seleniumemulation.ElementFinder;
import org.openqa.selenium.internal.seleniumemulation.SeleneseCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveAllSelections
extends SeleneseCommand<Void> {
    private final ElementFinder finder;

    public RemoveAllSelections(ElementFinder finder) {
        this.finder = finder;
    }

    @Override
    protected Void handleSeleneseCommand(WebDriver driver, String locator, String value) {
        WebElement select = this.finder.findElement(driver, locator);
        List options = select.findElements(By.tagName((String)"option"));
        String multiple = select.getAttribute("multiple");
        if (multiple == null || "".equals(multiple)) {
            return null;
        }
        this.removeAllSelections(options);
        return null;
    }

    private void removeAllSelections(List<WebElement> options) {
        for (WebElement option : options) {
            if (!option.isSelected()) continue;
            option.toggle();
        }
    }
}

