/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;

public class HttpRequest
extends HttpMessage<HttpRequest> {
    private final HttpMethod method;
    private final String uri;
    private final Map<String, List<String>> queryParameters = new LinkedHashMap<String, List<String>>();

    public HttpRequest(HttpMethod method, String uri) {
        this.method = method;
        this.uri = uri;
    }

    public HttpRequest(HttpMethod method, URI uri) {
        this(method, uri.toString());
    }

    public String getUri() {
        return this.uri;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getQueryParameter(String name) {
        Iterable<String> allParams = this.getQueryParameters(name);
        if (allParams == null) {
            return null;
        }
        Iterator<String> iterator = allParams.iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    public HttpRequest addQueryParameter(String name, String value) {
        this.queryParameters.computeIfAbsent((String)Require.nonNull((String)"Name", (Object)name), n -> new ArrayList()).add((String)Require.nonNull((String)"Value", (Object)value));
        return this;
    }

    public Iterable<String> getQueryParameterNames() {
        return this.queryParameters.keySet();
    }

    public Iterable<String> getQueryParameters(String name) {
        return this.queryParameters.get(name);
    }

    @Override
    public String toString() {
        String content = super.toString();
        return content.isEmpty() ? String.format("(%s) %s", new Object[]{this.getMethod(), this.getUri()}) : String.format("(%s) %s %s", new Object[]{this.getMethod(), this.getUri(), content});
    }
}

