/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.client;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openqa.selenium.docker.Image;
import org.openqa.selenium.docker.client.AdapterFactory;
import org.openqa.selenium.docker.client.ApiVersionAdapter;
import org.openqa.selenium.docker.client.DockerMessages;
import org.openqa.selenium.docker.internal.ImageSummary;
import org.openqa.selenium.docker.internal.Reference;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.TypeToken;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class ListImages {
    private static final Json JSON = new Json();
    private static final Type SET_OF_IMAGE_SUMMARIES = new TypeToken<Set<ImageSummary>>(){}.getType();
    private final HttpHandler client;
    private final String apiVersion;
    private final ApiVersionAdapter adapter;

    public ListImages(HttpHandler client, String apiVersion) {
        this(client, apiVersion, AdapterFactory.createAdapter(apiVersion));
    }

    public ListImages(HttpHandler client, String apiVersion, ApiVersionAdapter adapter) {
        this.client = (HttpHandler)Require.nonNull((String)"HTTP client", (Object)client);
        this.apiVersion = (String)Require.nonNull((String)"API version", (Object)apiVersion);
        this.adapter = (ApiVersionAdapter)Require.nonNull((String)"API version adapter", (Object)adapter);
    }

    public Set<Image> apply(Reference reference) {
        Require.nonNull((String)"Reference to search for", (Object)reference);
        String familiarName = reference.getFamiliarName();
        Map<String, Map<String, Boolean>> filters = Map.of("reference", Map.of(familiarName, true));
        HttpRequest req = ((HttpRequest)new HttpRequest(HttpMethod.GET, String.format("/v%s/images/json", this.apiVersion)).addHeader("Content-Type", "application/json; charset=utf-8")).addQueryParameter("filters", JSON.toJson(filters));
        HttpResponse response = DockerMessages.throwIfNecessary(this.client.execute(req), "Unable to list images for %s", reference);
        Set images = (Set)JSON.toType(Contents.string((HttpMessage)response), SET_OF_IMAGE_SUMMARIES);
        return images.stream().map(Image::new).collect(Collectors.toUnmodifiableSet());
    }
}

