/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;

public interface Capabilities
extends Serializable {
    default public String getBrowserName() {
        return String.valueOf(Optional.ofNullable(this.getCapability("browserName")).orElse(""));
    }

    default public @Nullable Platform getPlatformName() {
        return Stream.of("platformName").map(this::getCapability).filter(Objects::nonNull).map(cap -> {
            if (cap instanceof Platform) {
                return (Platform)((Object)((Object)cap));
            }
            try {
                return Platform.fromString(String.valueOf(cap));
            }
            catch (WebDriverException e) {
                return null;
            }
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    default public String getBrowserVersion() {
        return String.valueOf(Optional.ofNullable(this.getCapability("browserVersion")).orElse(""));
    }

    public Map<String, Object> asMap();

    public @Nullable Object getCapability(String var1);

    default public boolean is(String capabilityName) {
        Object cap = this.getCapability(capabilityName);
        if (cap == null) {
            return false;
        }
        return cap instanceof Boolean ? (Boolean)cap : Boolean.parseBoolean(String.valueOf(cap));
    }

    default public Capabilities merge(Capabilities other) {
        return new ImmutableCapabilities(new MutableCapabilities(this).merge(other));
    }

    default public Set<String> getCapabilityNames() {
        return Collections.unmodifiableSet(this.asMap().keySet());
    }
}

