/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import org.json.JSONObject;

public class LogEntry {
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT = new ThreadLocal();
    private static final String DATE_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ssZ";
    private final Level level;
    private final long timestamp;
    private final String message;

    public LogEntry(Level level, long timestamp, String message) {
        this.level = level;
        this.timestamp = timestamp;
        this.message = message;
    }

    public Level getLevel() {
        return this.level;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return String.format("[%s] [%s] %s", this.getDateFormat().format(new Date(this.timestamp)), this.level, this.message);
    }

    private SimpleDateFormat getDateFormat() {
        SimpleDateFormat format = DATE_FORMAT.get();
        if (format == null) {
            format = new SimpleDateFormat(DATE_FORMAT_STRING);
            DATE_FORMAT.set(format);
        }
        return format;
    }

    public JSONObject toJson() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("timestamp", this.timestamp);
        map.put("level", this.level);
        map.put("message", this.message);
        return new JSONObject(map);
    }
}

