/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.browserlaunchers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class DoNotUseProxyPac
implements Serializable {
    private static final Pattern acceptableShExpPattern = Pattern.compile("[\\w\\*\\?:/\\.-]*");
    private final Set<String> directUrls = new LinkedHashSet<String>();
    private final Map<String, String> proxiedUrls = new HashMap<String, String>();
    private final Map<String, String> proxiedRegexUrls = new HashMap<String, String>();
    private final Set<String> directHosts = new LinkedHashSet<String>();
    private final Map<String, String> proxiedHosts = new HashMap<String, String>();
    private String defaultProxy = "";
    private URI deriveFrom;

    public void outputTo(Writer writer) throws IOException {
        this.appendSuperPac(writer);
        writer.append("function FindProxyForURL(url, host) {\n");
        this.appendDirectHosts(writer);
        this.appendProxiedHosts(writer);
        this.appendDirectUrls(writer);
        this.appendProxiedUrls(writer);
        this.appendProxiedRegExUrls(writer);
        this.appendFallbackToSuperPac(writer);
        if (!"".equals(this.defaultProxy)) {
            writer.append("  return ").append(this.defaultProxy).append(";\n");
        }
        writer.append("}\n");
    }

    private void appendSuperPac(Writer writer) throws IOException {
        if (this.deriveFrom == null) {
            return;
        }
        InputStreamReader reader = new InputStreamReader((InputStream)this.deriveFrom.toURL().getContent());
        StringBuilder content = new StringBuilder();
        int i = ((Reader)reader).read();
        while (i != -1) {
            content.append((char)i);
            i = ((Reader)reader).read();
        }
        writer.append(content.toString().replace("FindProxyForURL", "originalFindProxyForURL"));
        writer.append("\n");
    }

    private void appendFallbackToSuperPac(Writer writer) throws IOException {
        if (this.deriveFrom == null) {
            return;
        }
        writer.append("\n").append("  var value = originalFindProxyForURL(host, url);\n").append("  if (value) { return value; }\n\n");
    }

    private void appendDirectHosts(Writer writer) throws IOException {
        for (String host : this.directHosts) {
            writer.append("  if (shExpMatch(host, '").append(host).append("')) { return 'DIRECT'; }\n");
        }
    }

    private void appendProxiedHosts(Writer writer) throws IOException {
        for (Map.Entry<String, String> entry : this.proxiedHosts.entrySet()) {
            writer.append("  if (shExpMatch(host, '").append(entry.getKey()).append("')) { return 'PROXY ").append(entry.getValue()).append("'; }\n");
        }
    }

    private void appendDirectUrls(Writer writer) throws IOException {
        for (String url : this.directUrls) {
            writer.append("  if (shExpMatch(url, '").append(url).append("')) { return 'DIRECT'; }\n");
        }
    }

    private void appendProxiedUrls(Writer writer) throws IOException {
        for (Map.Entry<String, String> entry : this.proxiedUrls.entrySet()) {
            writer.append("  if (shExpMatch(url, '").append(entry.getKey()).append("')) { return 'PROXY ").append(entry.getValue()).append("'; }\n");
        }
    }

    private void appendProxiedRegExUrls(Writer writer) throws IOException {
        for (Map.Entry<String, String> entry : this.proxiedRegexUrls.entrySet()) {
            writer.append("  if (").append(entry.getKey()).append(".test(url)) { return 'PROXY ").append(entry.getValue()).append("'; }\n");
        }
    }

    public ProxyUrlVia map(String outgoingUrl) {
        return new ProxyUrlVia(outgoingUrl);
    }

    public ProxyHostVia mapHost(String hostname) {
        return new ProxyHostVia(hostname);
    }

    public DefaultProxy defaults() {
        return new DefaultProxy();
    }

    public Map asMap() {
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        if (!this.directUrls.isEmpty()) {
            toReturn.put("directUrls", Collections.unmodifiableSet(this.directUrls));
        }
        if (!this.proxiedUrls.isEmpty()) {
            toReturn.put("proxiedUrls", Collections.unmodifiableMap(this.proxiedUrls));
        }
        if (!this.proxiedRegexUrls.isEmpty()) {
            toReturn.put("proxiedRegexUrls", Collections.unmodifiableMap(this.proxiedRegexUrls));
        }
        if (!this.directHosts.isEmpty()) {
            toReturn.put("directHosts", Collections.unmodifiableSet(this.directHosts));
        }
        if (!this.proxiedHosts.isEmpty()) {
            toReturn.put("proxiedHosts", Collections.unmodifiableMap(this.proxiedHosts));
        }
        if (!this.defaultProxy.isEmpty()) {
            toReturn.put("defaultProxy", this.defaultProxy);
        }
        if (this.deriveFrom != null) {
            toReturn.put("deriveFrom", this.deriveFrom.toString());
        }
        return toReturn;
    }

    public DoNotUseProxyPac deriveFrom(URI uri) {
        this.deriveFrom = uri;
        return this;
    }

    public class DefaultProxy {
        public DoNotUseProxyPac toNoProxy() {
            DoNotUseProxyPac.this.defaultProxy = "'DIRECT'";
            return DoNotUseProxyPac.this;
        }

        public DoNotUseProxyPac toProxy(String proxyVia) {
            DoNotUseProxyPac.this.defaultProxy = "'PROXY " + proxyVia + "'";
            return DoNotUseProxyPac.this;
        }
    }

    public class ProxyHostVia {
        private String host;

        private ProxyHostVia(String host) {
            this.host = host;
        }

        public DoNotUseProxyPac toProxy(String proxyVia) {
            DoNotUseProxyPac.this.proxiedHosts.put(this.host, proxyVia);
            return DoNotUseProxyPac.this;
        }

        public DoNotUseProxyPac toNoProxy() {
            DoNotUseProxyPac.this.directHosts.add(this.host);
            return DoNotUseProxyPac.this;
        }
    }

    public class ProxyUrlVia {
        private String outgoingUrl;

        private ProxyUrlVia(String outgoingUrl) {
            this.outgoingUrl = outgoingUrl;
        }

        public DoNotUseProxyPac toProxy(String proxyVia) {
            if (this.isIeIncompatibleRegEx(this.outgoingUrl)) {
                DoNotUseProxyPac.this.proxiedRegexUrls.put(this.outgoingUrl, proxyVia);
            } else {
                DoNotUseProxyPac.this.proxiedUrls.put(this.outgoingUrl, proxyVia);
            }
            return DoNotUseProxyPac.this;
        }

        private boolean isIeIncompatibleRegEx(String outgoingUrl) {
            return !acceptableShExpPattern.matcher(outgoingUrl).matches();
        }

        public DoNotUseProxyPac toNoProxy() {
            DoNotUseProxyPac.this.directUrls.add(this.outgoingUrl);
            return DoNotUseProxyPac.this;
        }
    }
}

