/**
 * 
 */
package org.richfaces.taglib;

import javax.faces.validator.Validator;

import org.richfaces.validator.FacesBeanValidator;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.jsf.ValidateHandler;
import com.sun.facelets.tag.jsf.ValidatorConfig;

/**
 * @author asmirnov
 * 
 */
public class BeanValidatorHandler extends ValidateHandler {

	private TagAttribute _summary;

	/**
	 * @param config
	 */
	public BeanValidatorHandler(TagConfig config) {
		super(config);
		_summary = getAttribute("summary");
	}

	@Override
	protected Validator createValidator(FaceletContext ctx) {
		FacesBeanValidator validator = (FacesBeanValidator) ctx.getFacesContext()
				.getApplication().createValidator(
						FacesBeanValidator.BEAN_VALIDATOR_TYPE);
		if (null != _summary) {
			validator
					.setSummary(_summary.getValueExpression(ctx, String.class));
		}
		return validator;
	}

}
