/**
 * 
 */
package org.richfaces.convert.rowkey;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;

import org.richfaces.model.ScrollableTableDataModel.SimpleRowKey;

/**
 * Converter for {@link SimpleRowKey} 
 * @author Maksim Kaszynski
 *
 */
public class ScrollableDataTableRowKeyConverter implements Converter {

	
	public static final String CONVERTER_ID = "org.richfaces.convert.rowkey.ScrollableDataTableRowKeyConverter";
	
	/* (non-Javadoc)
	 * @see javax.faces.convert.Converter#getAsObject(javax.faces.context.FacesContext, javax.faces.component.UIComponent, java.lang.String)
	 */
	public Object getAsObject(FacesContext context, UIComponent component,
			String value) {
		try {
			int i = Integer.parseInt(value);
			return new SimpleRowKey(i);
		} catch(Exception e) {
			throw new ConverterException("Unable to convert value " + value + "to " + SimpleRowKey.class, e);
		}
	}

	/* (non-Javadoc)
	 * @see javax.faces.convert.Converter#getAsString(javax.faces.context.FacesContext, javax.faces.component.UIComponent, java.lang.Object)
	 */
	public String getAsString(FacesContext context, UIComponent component,
			Object value) {
		if (value instanceof SimpleRowKey) {
			SimpleRowKey key = (SimpleRowKey) value;
			return key.toString();
		}
		throw new ConverterException("Value " + value + " is not supported by this converter");
	}

}
