package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIHotKey;

public class HtmlHotKey extends UIHotKey{

static public final  String COMPONENT_FAMILY = "org.richfaces.HotKey";

static public final  String COMPONENT_TYPE = "org.richfaces.HotKey";

/*
* Defines the hotkey handling of events generated by child components nested into the parent component to which the &amp;lt;rich:hotKey&amp;gt; is attached.
*/
private  Boolean _checkParent = null;

/*
* Disables the hotkeys activated on input elements when the value of this attribute is "true".
*/
private  Boolean _disableInInput = null;

/*
* Defines the types of the inputs not to be influenced with hotKey component. Possible values: buttons, texts and all (default). By default it is empty and this means ALL the types.
*/
private  String _disableInInputTypes = null;

/*
* Defines the JavaScript function name which is called on hotkey activation
*/
private  String _handler = null;

/*
* Defines the hotkey itself
*/
private  String _key = null;

/*
* Defines a selector for query
*/
private  String _selector = null;

/*
* Defines the time when the hotkey is registered. Possible values are "immediate" (by default), "onload", and "onregistercall".
*/
private  String _timing = null;

/*
* Defines the type of a keyboard event (onkeyup, onkeypress, etc.)
*/
private  String _type = null;


public HtmlHotKey(){
setRendererType("org.richfaces.HotKeyRenderer");
}

public Boolean getCheckParent(){
	if (this._checkParent != null) {
		return this._checkParent;
	}
	ValueExpression ve = getValueExpression("checkParent");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCheckParent(Boolean _checkParent){
this._checkParent = _checkParent;
}

public Boolean getDisableInInput(){
	if (this._disableInInput != null) {
		return this._disableInInput;
	}
	ValueExpression ve = getValueExpression("disableInInput");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setDisableInInput(Boolean _disableInInput){
this._disableInInput = _disableInInput;
}

public String getDisableInInputTypes(){
	if (this._disableInInputTypes != null) {
		return this._disableInInputTypes;
	}
	ValueExpression ve = getValueExpression("disableInInputTypes");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "all";
	

}

public void setDisableInInputTypes(String _disableInInputTypes){
this._disableInInputTypes = _disableInInputTypes;
}

public String getHandler(){
	if (this._handler != null) {
		return this._handler;
	}
	ValueExpression ve = getValueExpression("handler");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setHandler(String _handler){
this._handler = _handler;
}

public String getKey(){
	if (this._key != null) {
		return this._key;
	}
	ValueExpression ve = getValueExpression("key");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setKey(String _key){
this._key = _key;
}

public String getSelector(){
	if (this._selector != null) {
		return this._selector;
	}
	ValueExpression ve = getValueExpression("selector");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setSelector(String _selector){
this._selector = _selector;
}

public String getTiming(){
	if (this._timing != null) {
		return this._timing;
	}
	ValueExpression ve = getValueExpression("timing");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "immediate";
	

}

public void setTiming(String _timing){
this._timing = _timing;
}

public String getType(){
	if (this._type != null) {
		return this._type;
	}
	ValueExpression ve = getValueExpression("type");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setType(String _type){
this._type = _type;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[9];
state[0] = super.saveState(context);
state[1] = _checkParent;
state[2] = _disableInInput;
state[3] = _disableInInputTypes;
state[4] = _handler;
state[5] = _key;
state[6] = _selector;
state[7] = _timing;
state[8] = _type;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_checkParent = (Boolean)states[1];;
		_disableInInput = (Boolean)states[2];;
		_disableInInputTypes = (String)states[3];;
		_handler = (String)states[4];;
		_key = (String)states[5];;
		_selector = (String)states[6];;
		_timing = (String)states[7];;
		_type = (String)states[8];;
	
}

}
