/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.make;

import aQute.bnd.service.MakePlugin;
import aQute.lib.osgi.Builder;
import aQute.lib.osgi.Instruction;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Resource;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Make {
    Builder builder;
    Map<Instruction, Map<String, String>> make;

    public Make(Builder builder) {
        this.builder = builder;
    }

    public Resource process(String source) {
        Map<Instruction, Map<String, String>> make = this.getMakeHeader();
        this.builder.trace("make " + source, new Object[0]);
        for (Map.Entry<Instruction, Map<String, String>> entry : make.entrySet()) {
            Instruction instr = entry.getKey();
            Matcher m = instr.getMatcher(source);
            if (!m.matches() && !instr.isNegated()) continue;
            Map<String, String> arguments = this.replace(m, entry.getValue());
            List<MakePlugin> plugins = this.builder.getPlugins(MakePlugin.class);
            for (MakePlugin plugin : plugins) {
                try {
                    Resource resource = plugin.make(this.builder, source, arguments);
                    if (resource == null) continue;
                    this.builder.trace("Made " + source + " from args " + arguments + " with " + plugin, new Object[0]);
                    return resource;
                }
                catch (Exception e) {
                    this.builder.error("Plugin " + plugin + " generates error when use in making " + source + " with args " + arguments, e, new Object[0]);
                }
            }
        }
        return null;
    }

    private Map<String, String> replace(Matcher m, Map<String, String> value) {
        Map<String, String> newArgs = Processor.newMap();
        for (Map.Entry<String, String> entry : value.entrySet()) {
            String s = entry.getValue();
            s = this.replace(m, s);
            newArgs.put(entry.getKey(), s);
        }
        return newArgs;
    }

    String replace(Matcher m, CharSequence s) {
        StringBuffer sb = new StringBuffer();
        int max = 48 + m.groupCount() + 1;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '$' && i < s.length() - 1) {
                if ((c = s.charAt(++i)) >= '0' && c <= max) {
                    int index = c - 48;
                    String replacement = m.group(index);
                    if (replacement != null) {
                        sb.append(replacement);
                    }
                } else {
                    if (c == '$') {
                        ++i;
                    }
                    sb.append(c);
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    Map<Instruction, Map<String, String>> getMakeHeader() {
        if (this.make != null) {
            return this.make;
        }
        this.make = Processor.newMap();
        String s = this.builder.getProperty("-make");
        Map<String, Map<String, String>> make = this.builder.parseHeader(s);
        for (Map.Entry<String, Map<String, String>> entry : make.entrySet()) {
            String pattern = Processor.removeDuplicateMarker(entry.getKey());
            Instruction instr = Instruction.getPattern(pattern);
            this.make.put(instr, entry.getValue());
        }
        return this.make;
    }
}

