/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.bulk;

import jakarta.json.stream.JsonGenerator;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.JsonpSerializer;
import org.opensearch.client.json.JsonpUtils;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch.core.bulk.BulkOperationBase;
import org.opensearch.client.util.ObjectBuilder;

public class UpdateOperationData<TDocument>
implements JsonpSerializable {
    @Nullable
    private final TDocument document;
    @Nullable
    private final Boolean docAsUpsert;
    @Nullable
    private final TDocument upsert;
    @Nullable
    private final Script script;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;

    private UpdateOperationData(Builder<TDocument> builder) {
        this.document = builder.document;
        this.docAsUpsert = builder.docAsUpsert;
        this.script = builder.script;
        this.upsert = builder.upsert;
        this.tDocumentSerializer = builder.tDocumentSerializer;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.docAsUpsert != null) {
            generator.writeKey("doc_as_upsert");
            generator.write(this.docAsUpsert.booleanValue());
        }
        if (this.document != null) {
            generator.writeKey("doc");
            JsonpUtils.serialize(this.document, generator, this.tDocumentSerializer, mapper);
        }
        if (this.upsert != null) {
            generator.writeKey("upsert");
            JsonpUtils.serialize(this.upsert, generator, this.tDocumentSerializer, mapper);
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
    }

    public static class Builder<TDocument>
    extends BulkOperationBase.AbstractBuilder<Builder<TDocument>>
    implements ObjectBuilder<UpdateOperationData<TDocument>> {
        @Nullable
        private TDocument document;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;
        @Nullable
        private Boolean docAsUpsert;
        @Nullable
        private TDocument upsert;
        @Nullable
        private Script script;

        public final Builder<TDocument> document(TDocument value) {
            this.document = value;
            return this;
        }

        public final Builder<TDocument> docAsUpsert(@Nullable Boolean value) {
            this.docAsUpsert = value;
            return this;
        }

        public final Builder<TDocument> upsert(@Nullable TDocument value) {
            this.upsert = value;
            return this;
        }

        public final Builder<TDocument> script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        public final Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        protected Builder<TDocument> self() {
            return this;
        }

        @Override
        public UpdateOperationData<TDocument> build() {
            this._checkSingleUse();
            return new UpdateOperationData(this);
        }
    }
}

