/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.debug;

import java.util.Map;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.debug.DebugChemObjectBuilder;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class DebugChemModel
extends ChemModel
implements IChemModel {
    private static final long serialVersionUID = -920209300005079592L;
    ILoggingTool logger = LoggingToolFactory.createLoggingTool(DebugChemModel.class);

    public void addListener(IChemObjectListener col) {
        this.logger.debug((Object)"Adding listener: ", new Object[]{col});
        super.addListener(col);
    }

    public int getListenerCount() {
        this.logger.debug((Object)"Getting listener count: ", new Object[]{super.getListenerCount()});
        return super.getListenerCount();
    }

    public void removeListener(IChemObjectListener col) {
        this.logger.debug((Object)"Removing listener: ", new Object[]{col});
        super.removeListener(col);
    }

    public void notifyChanged() {
        this.logger.debug((Object)"Notifying changed");
        super.notifyChanged();
    }

    public void notifyChanged(IChemObjectChangeEvent evt) {
        this.logger.debug((Object)"Notifying changed event: ", new Object[]{evt});
        super.notifyChanged(evt);
    }

    public void setProperty(Object description, Object property) {
        this.logger.debug((Object)"Setting property: ", new Object[]{description + "=" + property});
        super.setProperty(description, property);
    }

    public void removeProperty(Object description) {
        this.logger.debug((Object)"Removing property: ", new Object[]{description});
        super.removeProperty(description);
    }

    public <T> T getProperty(Object description) {
        this.logger.debug((Object)"Getting property: ", new Object[]{description + "=" + super.getProperty(description)});
        return (T)super.getProperty(description);
    }

    public Map<Object, Object> getProperties() {
        this.logger.debug((Object)"Getting properties");
        return super.getProperties();
    }

    public String getID() {
        this.logger.debug((Object)"Getting ID: ", new Object[]{super.getID()});
        return super.getID();
    }

    public void setID(String identifier) {
        this.logger.debug((Object)"Setting ID: ", new Object[]{identifier});
        super.setID(identifier);
    }

    public void setFlag(int flagType, boolean flagValue) {
        this.logger.debug((Object)"Setting flag: ", new Object[]{flagType + "=" + flagValue});
        super.setFlag(flagType, flagValue);
    }

    public boolean getFlag(int flagType) {
        this.logger.debug((Object)"Setting flag: ", new Object[]{flagType + "=" + super.getFlag(flagType)});
        return super.getFlag(flagType);
    }

    public void addProperties(Map<Object, Object> properties) {
        this.logger.debug((Object)"Setting properties: ", new Object[]{properties});
        super.addProperties(properties);
    }

    public void setFlags(boolean[] flagsNew) {
        this.logger.debug((Object)"Setting flags:", new Object[]{flagsNew.length});
        super.setFlags(flagsNew);
    }

    public boolean[] getFlags() {
        this.logger.debug((Object)"Getting flags:", new Object[]{super.getFlags().length});
        return super.getFlags();
    }

    public Object clone() throws CloneNotSupportedException {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (Exception exception) {
            this.logger.error((Object)("Could not clone DebugAtom: " + exception.getMessage()), new Object[]{exception});
            this.logger.debug((Object)exception);
        }
        return clone;
    }

    public IChemObjectBuilder getBuilder() {
        return DebugChemObjectBuilder.getInstance();
    }

    public IAtomContainerSet getMoleculeSet() {
        this.logger.debug((Object)"Getting setOfMolecules: ", new Object[]{super.getMoleculeSet()});
        return super.getMoleculeSet();
    }

    public void setMoleculeSet(IAtomContainerSet setOfMolecules) {
        this.logger.debug((Object)"Setting setOfMolecules: ", new Object[]{setOfMolecules});
        super.setMoleculeSet(setOfMolecules);
    }

    public IRingSet getRingSet() {
        this.logger.debug((Object)"Getting ringSet: ", new Object[]{super.getRingSet()});
        return super.getRingSet();
    }

    public void setRingSet(IRingSet ringSet) {
        this.logger.debug((Object)"Setting ringSet: ", new Object[]{ringSet});
        super.setRingSet(ringSet);
    }

    public ICrystal getCrystal() {
        this.logger.debug((Object)"Getting crystal: ", new Object[]{super.getCrystal()});
        return super.getCrystal();
    }

    public void setCrystal(ICrystal crystal) {
        this.logger.debug((Object)"Setting crystal: ", new Object[]{crystal});
        super.setCrystal(crystal);
    }

    public IReactionSet getReactionSet() {
        this.logger.debug((Object)"Getting setOfReactions: ", new Object[]{super.getReactionSet()});
        return super.getReactionSet();
    }

    public void setReactionSet(IReactionSet sor) {
        this.logger.debug((Object)"Setting setOfReactions: ", new Object[]{sor});
        super.setReactionSet(sor);
    }

    public boolean isEmpty() {
        boolean res = true;
        if (this.setOfMolecules != null && !this.setOfMolecules.isEmpty()) {
            res = false;
        }
        if (this.setOfReactions != null && !this.setOfReactions.isEmpty()) {
            res = false;
        }
        if (this.ringSet != null && !this.ringSet.isEmpty()) {
            res = false;
        }
        if (this.crystal != null && !this.crystal.isEmpty()) {
            res = false;
        }
        this.logger.debug((Object)"Checking if chemModel is empty: ", new Object[]{res});
        return res;
    }
}

