/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class ChangeDefaultKeyStore
extends Recipe {
    private static final MethodMatcher KEYSTORE_METHOD_REF = new MethodMatcher("java.security.KeyStore getDefaultType()", true);

    public String getDisplayName() {
        return "Return String `jks` when  `KeyStore.getDefaultType()` is called";
    }

    public String getDescription() {
        return "In Java 11 the default keystore was updated from JKS to PKCS12. As a result, applications relying on KeyStore.getDefaultType() may encounter issues after migrating, unless their JKS keystore has been converted to PKCS12. This recipe returns default key store of `jks` when `KeyStore.getDefaultType()` method is called to use the pre Java 11 default keystore.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(11, 11), new UsesMethod(KEYSTORE_METHOD_REF)}), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (KEYSTORE_METHOD_REF.matches((MethodCall)method)) {
                    return new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)"\"jks\"", "\"jks\"", null, JavaType.Primitive.String);
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }
}

